package com.elitescloud.cloudt.sys.outlog.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/24 周二
 */
@Entity
@Table(name = "outside_push_fail_record", indexes = {
        @Index(name = "idx_push_fail_docno", columnList = "docNo"),
        @Index(name = "idx_push_fail_docid", columnList = "docId"),
})
@Comment("推送失败记录")
@Getter
@Setter
public class OutsidePushFailRecordDO extends BaseModel {
    private static final long serialVersionUID = -7508118338254423935L;

    /**
     * @see com.elitesland.pur.constants.PurPushTarget
     */
    @Column()
    @Comment(value = "目标类型")
    private String targetType;

    /**
     * @see com.elitesland.pur.constants.PurPushDocType
     */
    @Column()
    @Comment(value = "单据类型")
    private String docType;

    @Column()
    @Comment(value = "单据编号")
    private String docNo;

    @Column()
    @Comment(value = "单据ID")
    private Long docId;

    /**
     * @see com.elitesland.pur.constants.PurPushInter
     */
    @Column()
    @Comment(value = "接口编码")
    private String interCode;

    @Lob
    @Column()
    @Comment(value = "失败原因")
    private String failReason;

    @Column()
    @Comment(value = "重试次数", defaultValue = "0")
    private Integer retryTimes;
}

    