package com.elitescloud.cloudt.sys.outlog.rpc;

import com.elitescloud.cloudt.sys.Application;
import com.elitescloud.cloudt.sys.outlog.OutsideInter;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OutsidePushRecordRepository.PATH)
@Validated
public interface OutsidePushRecordRepository {

    String PATH = "/outsidePush";

    /**
     * 保存待重试的失败记录
     * <p>
     * docId和docNo不能同时为空
     *
     * @param inter
     * @param docId
     * @param docNo
     * @param errorMsg
     */
    @PostMapping("/saveFailRecord")
    void saveFailRecord(@RequestBody PushRecordDTO pushRecordDTO);

    /**
     * 保存推送记录
     *
     * @param inter
     * @param docNo
     * @param docId
     * @param queryParams
     * @param reqBody
     * @param reqSuccess
     * @param reqTime
     * @param respBody
     * @param errorMsg
     */
    @PostMapping("/savePushRecord")
    Long savePushRecord(@RequestBody PushRecordDTO pushRecordDTO);
}

    