package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serial;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 医药基础实体类-订单.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/22 周一
 */
@Getter
@Setter
@MappedSuperclass
public class BaseModelMedOrderD extends BaseModelMedItem {
    @Serial
    private static final long serialVersionUID = 4025026154940172370L;

    @Column(length = 32)
    @Comment(value = "图稿编号")
    private String draftNo;

    @Column()
    @Comment(value = "生产日期")
    private LocalDateTime produceDate;

    @Column()
    @Comment(value = "有效期至")
    private LocalDateTime expiredDate;

    @Column()
    @Comment(value = "产品批号")
    private String productNo;


    @Column()
    @Comment(value = "是否赠品")
    private Boolean giftFlag;

    @Column()
    @Comment(value = "订货单位")
    private String orderUom;

    @Column()
    @Comment(value = "订货数量")
    private BigDecimal orderNum;

    @Column()
    @Comment(value = "发货数量")
    private BigDecimal shipNum;

    @Column()
    @Comment(value = "应检数量")
    private BigDecimal inspectNum;

    @Column()
    @Comment(value = "采购价格")
    private BigDecimal purchasePrice;

    @Column()
    @Comment(value = "税率")
    private BigDecimal taxRate;

    @Column()
    @Comment(value = "含税金额")
    private BigDecimal amt;

    @Column()
    @Comment(value = "未税金额")
    private BigDecimal netAmt;

    @Column(length = 32)
    @Comment(value = "合同号")
    private String contractNo;

    @Column(length = 32)
    @Comment(value = "项目编号")
    private String projNo;

    @Column(length = 32)
    @Comment(value = "项目名称")
    private String projName;



    @ApiModelProperty(value = "税率编号")
    @Column(name="tax_rate_no")
    @Comment("税率编号")
    private String taxRateNo ;


}
