package com.elitescloud.cloudt.sys.outlog;

import org.springframework.http.HttpMethod;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/24 周二
 */
public enum OutsidePushInter implements OutsideInter {

    SRM_PUR_PO_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[创建采购订单]", "/infinity/pur/purPo/save", HttpMethod.POST, false),
    SRM_PUR_PO_CLOSE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[关闭采购订单]", "/infinity/pur/purPo/close", HttpMethod.POST, false),
    SRM_PUR_PO_CANCEL(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[取消采购订单]", "/infinity/pur/app/purPo/cancel", HttpMethod.POST, false),
    SRM_PUR_PO_UPDATE_PAYMENT(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PO, "向SRM推送[更新采购订单的支付状态]", "/infinity/pur/purPo/update", HttpMethod.POST, false),
    SRM_PUR_PG_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_PG, "向SRM推送[创建采购收货单]", "/infinity/std/gr/put/save", HttpMethod.POST, false),
    SRM_PUR_RNS_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS, "向SRM推送[创建采购退货申请单]", "/infinity/purRns/rnsSave", HttpMethod.POST, false),
    SRM_PUR_RNS_CANCEL(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS, "向SRM推送[取消采购退货申请单]", "/infinity/purRns/rns/update", HttpMethod.POST, false),
    SRM_PUR_RNS_RECV_SAVE(OutsidePushTarget.SRM, OutsidePushDocType.PUR_RNS_REV, "向SRM推送[创建采购退货出库单]", "/infinity/std/gr/rns/save", HttpMethod.POST, false),

    BIP_PUR_GR_APPROVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_PG, "向BIP推送[采购订单审批]", "/nccloud/api/pu/order/operation/approve", HttpMethod.POST, false),
    BIP_PUR_GR_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_PG, "向BIP推送[采购订单](采购收货单)", "/nccloud/api/pu/order/operation/save", HttpMethod.POST, false),
    BIP_PUR_RNS_RECV_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_RNS_REV, "向BIP推送[采购订单](采购退货出库单)", "/nccloud/api/pu/order/operation/save", HttpMethod.POST, false),
    BIP_PUR_AP_SAVE(OutsidePushTarget.BIP, OutsidePushDocType.PUR_RNS_REV, "向BIP推送[应付单](采购收货单)", "/nccloud/api/arap/payablebill/insertandcommit", HttpMethod.POST, false),
    CUST_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.PUR_CUST, "中台推送[公司](客户主档)到NC", "/yst/sale/nc/retry/tryFun", HttpMethod.POST, true),
    NC_SUPP_OU(OutsidePushTarget.NC, OutsidePushDocType.SUPP_OU, "nc向中台推送[公司](公司列表)", "/yst/support/openApi/orgOu/saveOrgOu", HttpMethod.POST, false),

    ITEM_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.SUPPORT_ITEM, "中台推送[公司](商品主档)到NC", "/yst/support/nc/retry/tryFun", HttpMethod.POST, true),
    SUPPORT_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.PUR_SUPP, "中台推送[公司](供应商主档)到NC", "/yst/support/nc/retry/tryFun", HttpMethod.POST, true),
    SUPPORT_ITEM_DECLARE_INSPECT_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.SUPPORT_ITEM_DECLARE_INSPECT, "中台推送[商品报检单]到NC", "/yst/support/nc/retry/tryFun", HttpMethod.POST, true),


    ORDER_SAL_DO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.ORDER_SAL_DO, "中台推送[销售出库单]到NC", "/yst/order/nc/retry/tryFun", HttpMethod.POST, true),
    ORDER_SAL_RSO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.ORDER_SAL_RSO, "中台推送[销售退货入库单]到NC", "/yst/order/nc/retry/tryFun", HttpMethod.POST, true),
    ORDER_SALE_RECONCILIAT(OutsidePushTarget.NC, OutsidePushDocType.ORDER_SALE_RECONCILIAT, "中台推送[公司](销售对账单)到NC", "/yst/order/nc/retry/tryFun", HttpMethod.POST, true),

    WEAVER_E9_LOG(OutsidePushTarget.WEAVER_E9, OutsidePushDocType.SCM, "中台发起流程到泛微OA", "", HttpMethod.POST, false),

    INV_IDO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_IDO, "中台推送[采购入库单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ODO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ODO, "中台推送[采购退货出库单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ADJUST_IDO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ADJUST_IDO, "中台推送[库存调整入库单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_ADJUST_ODO_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_ADJUST_ODO, "中台推送[库存调整出库单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_AJ_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_AJ, "中台推送[产成品入库]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_AJD_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_AJD, "中台推送[领用申请单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),
    INV_AJ_MA_SYNC_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.INV_AJ_MA, "中台推送[车间发料单]到NC", "/yst/inv/nc/retry/tryFun", HttpMethod.POST, true),

    PUR_ACCOUNT_CHECK_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.PUR_ACCOUNT_CHECK, "中台推送[采购对账单]到NC", "/yst/pur/nc/retry/tryFun", HttpMethod.POST, true),

    FIN_PAY_ORDER_AP_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.FIN_PAY_ORDER_AP, "中台推送[付款申请单]到NC", "/yst/fin/nc/retry/tryFun", HttpMethod.POST, true),
    FIN_PAY_ORDER_YF_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.FIN_PAY_ORDER_YF, "中台推送[预付款申请单]到NC", "/yst/fin/nc/retry/tryFun", HttpMethod.POST, true),
    FIN_REC_ORDER_YS_TO_NC(OutsidePushTarget.NC, OutsidePushDocType.FIN_REC_ORDER_YS, "中台推送[预收款单]到NC", "/yst/fin/nc/retry/tryFun", HttpMethod.POST, true),
    ITEM_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.SUPPORT_ITEM, "中台推送[公司](商品主档)到吉客云", "/yst/support/jky/retry/tryFun", HttpMethod.POST, true),
    SUPPORT_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.PUR_SUPP, "中台推送[公司](供应商主档)到吉客云", "/yst/support/jky/retry/tryFun", HttpMethod.POST, true),

    ITEM_SYNC_TO_JST(OutsidePushTarget.JST, OutsidePushDocType.SUPPORT_ITEM, "中台推送[公司](商品主档)到聚水潭", "/yst/support/jst/retry/tryFun?url=/open/jushuitan/itemsku/upload", HttpMethod.POST, true),
    SUPPORT_SYNC_TO_JST(OutsidePushTarget.JST, OutsidePushDocType.PUR_SUPP, "中台推送[公司](供应商主档)到到聚水潭", "/yst/support/jst/retry/tryFun?url=/open/supplier/upload", HttpMethod.POST, true),
    INV_IDO_SYNC_TO_JST(OutsidePushTarget.JST, OutsidePushDocType.INV_IDO, "中台推送[采购入库单]到聚水潭", "/yst/pur/jst/retry/tryFun?url=/open/webapi/wmsapi/purchasein/createbatch", HttpMethod.POST, true),
    INV_ALLOCATE_SYNC_TO_JST(OutsidePushTarget.JST, OutsidePushDocType.INV_ALLOCATE, "中台推送[同公司跨仓调拨]到聚水潭", "/yst/pur/jst/retry/tryFun?url=/open/allocate/kc/upload", HttpMethod.POST, true),

    JST_INV_WH_TO_SCM(OutsidePushTarget.JST, OutsidePushDocType.INV_WH, "聚水潭查询仓库数据", "/yst/pur/jst/retry/tryFun?url=/open/wms/partner/query", HttpMethod.POST, false),
    JST_INV_IDO_RESULT_TO_SCM(OutsidePushTarget.JST, OutsidePushDocType.INV_IDO_RESULT, "聚水潭采购入库(结果)查询", "/yst/support/jst/retry/tryFun?url=/open/webapi/wmsapi/purchasein/purchaseinquery", HttpMethod.POST, false),

    JST_INV_ODO_RESULT_TO_SCM(OutsidePushTarget.JST, OutsidePushDocType.INV_ODO_RESULT, "聚水潭采购出库(结果)查询", "/yst/support/jst/retry/tryFun?url=/open/purchaseout/query", HttpMethod.POST, false),
    INV_ODO_SYNC_TO_JST(OutsidePushTarget.JST, OutsidePushDocType.INV_ODO, "中台推送[采购退货单]到聚水潭", "/yst/support/jst/retry/tryFun?url=/open/webapi/wmsapi/purchaseout/createbatch", HttpMethod.POST, true),

    INV_ODO_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.INV_IDO_RESULT, "中台推送[采购退货单查询]到吉客云", "/yst/support/jky/retry/tryFun?url=erp.storage.goodsdocout.v2", HttpMethod.POST, true),
    INV_ODO_CREATE_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.INV_ODO, "中台推送[采购退货单创建]到吉客云", "/yst/support/jky/retry/tryFun?url=erp.storage.stockoutcreate", HttpMethod.POST, true),
    INV_IDO_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.INV_IDO_RESULT, "中台推送[采购入库单查询]到吉客云", "/yst/support/jky/retry/tryFun?url=erp.stockin.getdetail", HttpMethod.POST, true),
    INV_IDO_CREATE_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.INV_ODO, "中台推送[采购入库单创建]到吉客云", "/yst/support/jky/retry/tryFun?url=erp.storage.stockincreate", HttpMethod.POST, true),
    INV_ORDER_SYNC_TO_JKY(OutsidePushTarget.JKY, OutsidePushDocType.INV_IDO_RESULT, "中台推送[销售订单查询]到吉客云", "/yst/support/jky/retry/tryFun?url=oms.trade.fullinfoget", HttpMethod.POST, true),

    ;

    private final OutsidePushTarget target;
    private final OutsidePushDocType docType;
    private final String description;
    private final String uri;
    private final HttpMethod uriMethod;
    /**
     * 是否需要自动重试
     */
    private final Boolean needRetry;

    OutsidePushInter(OutsidePushTarget target, OutsidePushDocType docType, String description, String uri, HttpMethod uriMethod, Boolean needRetry) {
        this.target = target;
        this.docType = docType;
        this.description = description;
        this.uri = uri;
        this.uriMethod = uriMethod;
        this.needRetry = needRetry;
    }

    public OutsidePushTarget getTarget() {
        return target;
    }

    public OutsidePushDocType getDocType() {
        return docType;
    }

    public Boolean getNeedRetry() {
        return needRetry;
    }

    @Override
    public String getTargetSystem() {
        return target.name();
    }

    @Override
    public String getDocTypeCode() {
        return docType.name();
    }

    @Override
    public String getInterCode() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getUri() {
        return uri;
    }

    @Override
    public HttpMethod getUriMethod() {
        return uriMethod;
    }
}

    