package com.elitescloud.cloudt.sys.merchant.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.sys.Application;
import com.elitescloud.cloudt.sys.merchant.query.MerchantConfigQuery;
import com.elitescloud.cloudt.sys.merchant.vo.MerchantConfigVO;
import com.elitescloud.cloudt.sys.outlog.param.PushRecordDTO;
import com.elitescloud.cloudt.sys.outlog.rpc.OutsidePushRecordRepository;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/7/10 周四
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OutsidePushRecordRepository.PATH)
@Validated
public interface MerchantConfigProvider {

    String PATH = "/merchantConfig";


    @PostMapping("/queryList")
    ApiResult<List<MerchantConfigVO>> queryList(@RequestBody MerchantConfigQuery query);


    @PostMapping("/test")
    ApiResult<MerchantConfigQuery> test(@RequestBody MerchantConfigQuery query);


}

    