package com.elitescloud.cloudt.sys.merchant.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.sys.merchant.payload.MerchantConfigPayload;
import com.elitescloud.cloudt.sys.merchant.query.MerchantConfigQuery;
import com.elitescloud.cloudt.sys.merchant.vo.MerchantConfigVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 商户配置表
 *
 * @author duwh
 * @date 2025-11-11
 */
public interface MerchantConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link MerchantConfigVO}>
     */
    PagingVO<MerchantConfigVO> queryPaging(MerchantConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link MerchantConfigVO}>
     */
    List<MerchantConfigVO> queryListDynamic(MerchantConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link MerchantConfigVO}
     */
    MerchantConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link MerchantConfigVO}
     */
    MerchantConfigVO insert(MerchantConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link MerchantConfigVO}
     */
    MerchantConfigVO update(MerchantConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(MerchantConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
