package com.elitescloud.cloudt.sys.outlog;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.sys.outlog.entity.OutsidePushFailRecordDO;
import com.elitescloud.cloudt.sys.outlog.entity.QOutsidePushFailRecordDO;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/6/24 周二
 */
@Repository
public class OutsidePushFailRecordRepoProc extends BaseRepoProc<OutsidePushFailRecordDO> {
    private static final QOutsidePushFailRecordDO QDO = QOutsidePushFailRecordDO.outsidePushFailRecordDO;

    public OutsidePushFailRecordRepoProc() {
        super(QDO);
    }

    /**
     * 更新失败原因
     *
     * @param id
     * @param failMsg
     */
    @Transactional(rollbackFor = Exception.class)
    public void updateFailMsg(long id, String failMsg) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.failReason, failMsg)
                .set(QDO.retryTimes, QDO.retryTimes.add(1))
                .set(QDO.modifyTime, LocalDateTime.now())
                .where(QDO.id.eq(id).and(QDO.modifyTime.lt(LocalDateTime.now().minusMinutes(1))))
                .execute();
    }

    /**
     * 判断是否存在
     *
     * @param interCode
     * @param docId
     * @param docNo
     */
    public Long getId(@NotBlank String interCode, Long docId, String docNo) {
        BooleanExpression predicate = QDO.interCode.eq(interCode);
        if (docId != null) {
            predicate = predicate.and(QDO.docId.eq(docId));
        }
        if (docNo == null) {
            predicate = predicate.and(QDO.docNo.isNull());
        } else {
            predicate = predicate.and(QDO.docNo.eq(docNo));
        }

        return super.getIdByPredicate(predicate);
    }

    public List<OutsidePushFailRecordDO> allNeedRetry() {
        return super.getList(QDO.retryTimes.lt(10));
    }
}

    