package com.elitescloud.cloudt.sys.component.med;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.MappedSuperclass;
import java.io.Serial;

/**
 * 医药基础实体类-单据主表.
 *
 * @author nc
 * @date 2025/9/15 周一
 */
@Getter
@Setter
@MappedSuperclass
public class BaseModelMedOrderVO extends CustomFieldBaseModelVo {
    @Serial
    private static final long serialVersionUID = 8543635117696143981L;

    @ApiModelProperty("来源单据类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String rootDocCls;
    private String rootDocClsName;
    @ApiModelProperty("来源单据类型")
    @SysCode(sys = "yst-inv",mod =  "ROOT_DOC_TYPE")
    private String rootDocType;
    @ApiModelProperty("来源单据类型名称")
    private String rootDocTypeName;

    @ApiModelProperty("来源单据Id")
    private Long rootDocId;
    @ApiModelProperty("来源单据编号")
    private String rootDocNo;

    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    @ApiModelProperty("关联单据类别 默认入库单 [UDC] yst-inv:INV_DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;

    @ApiModelProperty("关联单据2类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDoc2Cls;
    private String relateDoc2ClsName;
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;

    @ApiModelProperty("客商ID")
    private Long enterpriseId;
    @ApiModelProperty("客商编码")
    private String enterpriseCode;
    @ApiModelProperty("客商名称")
    private String enterpriseName;
    @ApiModelProperty(value = "客商客商类型")
    @SysCode(sys = "yst-purc", mod = "ENTERPRISE_TYPE")
    private String enterpriseType;
    @ApiModelProperty(value = "客商客商类型名称")
    private String enterpriseTypeName;

    @ApiModelProperty(value = "是否免检")
    private Boolean qt;
}
