package com.elitesland.boot.autoconfigure.elasticsearch.config;

import cn.hutool.core.lang.Assert;
import com.elitesland.boot.elasticsearch.canal.config.CanalProperties;
import com.elitesland.boot.elasticsearch.canal.config.support.CanalHandlerCustomizer;
import com.elitesland.boot.elasticsearch.canal.config.support.DefaultCanalHandler;
import com.elitesland.boot.elasticsearch.canal.factory.CanalClientFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.NonNull;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/21
 */
@ConditionalOnProperty(prefix = "elitesland.elasticsearch.canal", name = "enable", havingValue = "true")
@EnableConfigurationProperties(CanalProperties.class)
class ElasticsearchCanalClientConfiguration implements BeanFactoryAware, ApplicationRunner {

    private BeanFactory beanFactory;

    @Bean
    @ConditionalOnMissingBean
    public CanalHandlerCustomizer canalHandlerCustomizer() {
        return new DefaultCanalHandler();
    }

    @Override
    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        new CanalClientFactory(beanFactory, beanFactory.getBean(CanalProperties.class)).build();
    }
}
