package com.elitesland.boot.elasticsearch;

import com.elitesland.boot.elasticsearch.canal.model.RowData;

import java.io.Serializable;

/**
 * canal客户端.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/20
 */
public interface CanalClient<T extends Serializable> {

    /**
     * 数据库名称
     *
     * @return 数据库名称
     */
    default String database() {
        return "";
    }

    /**
     * 数据库表名称
     *
     * @return 表名
     */
    String table();

    /**
     * 当插入数据时
     *
     * @param rowData 插入的数据
     */
    void onInsert(RowData<T> rowData);

    /**
     * 当更新数据时
     *
     * @param rowDataUpdateBefore 更新前的数据
     * @param rowDataUpdateAfter  更新后的数据
     */
    void onUpdate(RowData<T> rowDataUpdateBefore, RowData<T> rowDataUpdateAfter);

    /**
     * 当删除数据时
     *
     * @param rowData 删除的数据
     */
    void onDelete(RowData<T> rowData);
}
