package com.elitesland.boot.elasticsearch.annotation;

import com.elitesland.boot.elasticsearch.common.IndexCheck;

import java.lang.annotation.*;

/**
 * 将类标记为Elasticsearch中的document.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/24
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface DocumentSupport {

    /**
     * 索引检查策略
     *
     * @return 检查策略
     */
    IndexCheck checkStrategy() default IndexCheck.CREATE_IF_NO_EXIST;

    /**
     * 支持搜索自动补全的字段
     * <p>
     * 字段值的长度超过50后将被忽略
     *
     * @return 字段名称数组
     */
    String[] completionFields() default {};

    /**
     * 是否启用source字段
     *
     * @return 是否启用
     */
    boolean sourceEnabled() default true;

    /**
     * source中包含的字段
     * <p>
     * source = true时有效，支持通配符*和子字段（如：item*、item.attribute.pro*等）
     *
     * @return source包含字段
     */
    String[] sourceIncludes() default {};

    /**
     * source中排除的字段
     * <p>
     * source = true时有效，支持通配符*和子字段（如：item*、item.attribute.pro*等）
     *
     * @return source排除掉的字段
     */
    String[] sourceExcludes() default {};
}
