package com.elitesland.boot.elasticsearch.canal.config;

import org.springframework.boot.context.properties.ConfigurationProperties;

import java.time.Duration;

/**
 * canal相关配置.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/21
 */
@ConfigurationProperties(prefix = "elitesland.elasticsearch.canal")
public class CanalProperties {

    /**
     * 是否启用canal
     */
    private boolean enable = true;
    /**
     * 默认的数据库名
     */
    private String database;

    /**
     * 获取数据的时间间隔，默认1秒
     */
    private Duration periodRefresh = Duration.ofSeconds(1);
    /**
     * 每次从server获取数据量
     */
    private Integer batchSize = 100;
    /**
     * canal服务端配置
     */
    private final Server server = new Server();

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Duration getPeriodRefresh() {
        return periodRefresh;
    }

    public void setPeriodRefresh(Duration periodRefresh) {
        this.periodRefresh = periodRefresh;
    }

    public Integer getBatchSize() {
        return batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Server getServer() {
        return server;
    }

    public static class Server {

        /**
         * canal服务端地址
         */
        private String host;
        /**
         * canal服务端端口
         */
        private int port = 11111;
        /**
         * destination
         */
        private String destination = "example";
        /**
         * 用户名
         */
        private String username = "";
        /**
         * 密码
         */
        private String password = "";

        public String getHost() {
            return host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getDestination() {
            return destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public String getUsername() {
            return username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}
