package com.elitesland.boot.elasticsearch.canal.config.support;

import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

/**
 * 自定义处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/21
 */
public interface CanalHandlerCustomizer {

    /**
     * 自定义处理objectMapperBuilder
     * <p>
     * 在RowData的数据转换中用到
     *
     * @param jacksonObjectMapperBuilder objectMapperBuilder
     */
    void objectMapperBuilder(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder);

    /**
     * 数据库列名转换
     *
     * @param fieldName 列名
     * @return 转化后的属性名
     */
    String fieldNameConvert(String fieldName);
}
