package com.elitesland.boot.elasticsearch.canal.model;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 行数据.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/20
 */
@Data
public class RowData<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = -390773465851126105L;

    /**
     * 行数据
     */
    private T data;

    /**
     * 原始列的值
     */
    private List<Column> columnList;

    /**
     * 列和值
     */
    private Map<String, Serializable> valueMap;

    /**
     * 列数据
     */
    @Data
    public static class Column implements Serializable {
        private static final long serialVersionUID = -5783310661618979579L;

        /**
         * 列名称
         */
        private String name;

        /**
         * 值
         */
        private Serializable value;

        /**
         * 是否是空值
         */
        private boolean isNull;
    }
}
