package com.elitesland.boot.elasticsearch.common;

/**
 * 分词器.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/14
 */
public interface Analyzer {

    /**
     * ik中文分词器，颗粒度大，适应于保存时使用
     */
    String IK_MAX_WORD = "ik_max_word";

    /**
     * ik中文分词器，颗粒度小但精确，适应于查询时使用
     */
    String IK_SMART = "ik_smart";

    /**
     * 内置分词器，<span style="font-weight:bold; color:red;">默认分词器</span>，按单词切分，小写处理
     */
    String STANDARD = "standard";

    /**
     * 内置分词器，按非字母切分（符号被过滤），小写处理
     */
    String SIMPLE = "simple";

    /**
     * 内置分词器，空格分词器，按照空格分词
     */
    String WHITESPACE = "whitespace";

    /**
     * 内置分词器，小写处理，停用词（the、a、is等无意义的词）过滤
     */
    String STOP = "stop";

    /**
     * 不做分词，原样输入输出
     */
    String KEYWORD = "keyword";
}
