package com.elitesland.boot.elasticsearch.common;

import lombok.Data;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.core.completion.Completion;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 文档的基类.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/24
 */
@Data
@MappedSuperclass
public abstract class BaseDocument implements Serializable {
    private static final long serialVersionUID = 2204292204587067788L;

    /**
     * 数据的唯一标识
     */
    @Id
    @Field(type = FieldType.Long)
    private Long id;

    /**
     * 记录的创建时间
     */
    @Field(type = FieldType.Date, format = DateFormat.date_hour_minute_second)
    private LocalDateTime createTime;

    /**
     * 自动补全搜索
     */
    @CompletionField(analyzer = Analyzer.IK_MAX_WORD, searchAnalyzer = Analyzer.IK_SMART, maxInputLength = ConstantsEs.COMPLETION_LEN_MAX)
    private Completion completion;
}
