package com.elitesland.boot.elasticsearch.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 分页数据结果.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/06
 */
public class PageResult<T extends BaseDocument> implements Serializable {
    private static final long serialVersionUID = 7338596361008811849L;

    private long total;
    private List<T> recordList;

    public PageResult(long total, List<T> recordList) {
        this.total = Math.max(total, 0);
        this.recordList = recordList == null ? Collections.emptyList() : recordList;
    }

    public PageResult() {
        this.total = 0L;
        this.recordList = Collections.emptyList();
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getRecordList() {
        return recordList;
    }

    public <R> List<R> getRecordList(Function<T, R> convert) {
        if (this.recordList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.recordList.stream().map(convert).collect(Collectors.toList());
    }

    public void setRecordList(List<T> recordList) {
        this.recordList = recordList;
    }
}
