package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;

/**
 * 查询参数基类.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/11
 */
public abstract class AbstractDocumentParam<T extends BaseDocument> {

    /**
     * 文档类型
     */
    protected final Class<T> documentType;

    /**
     * 页码，最小为1
     */
    protected int page = 1;

    /**
     * 每页数据量
     */
    protected int pageSize = 10;

    public AbstractDocumentParam(Class<T> documentType) {
        this.documentType = documentType;
    }

    public AbstractDocumentParam<T> withPage(int page) {
        this.page = Math.max(1, page);
        return this;
    }

    public AbstractDocumentParam<T> withPageSize(int pageSize) {
        this.pageSize = Math.max(1, pageSize);
        return this;
    }

    public int getPage() {
        return page;
    }

    public int getPageSize() {
        return pageSize;
    }
}
