package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;

/**
 * 聚合参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/12
 */
public class AggregationParam<T extends BaseDocument> extends AbstractDocumentParam<T> {

    /**
     * 过滤器
     */
    private ConditionBuilder<T> filterBuilder;
    /**
     * 聚合函数
     */
    private final List<AbstractAggregationBuilder> aggregationBuilders;

    public AggregationParam(Class<T> documentType) {
        super(documentType);
        this.aggregationBuilders = new ArrayList<>(8);
    }

    public AggregationParam<T> withConditionFilter(ConditionBuilder<T> filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public AggregationParam<T> withAggregationBuilder(AbstractAggregationBuilder aggregationBuilder) {
        Assert.notNull(aggregationBuilder, "aggregationBuilder不能为空");
        this.aggregationBuilders.add(aggregationBuilder);
        return this;
    }

    public ConditionBuilder<T> getFilterBuilder() {
        return filterBuilder;
    }

    public List<AbstractAggregationBuilder> getAggregationBuilders() {
        return aggregationBuilders;
    }
}
