package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;

/**
 * 查询助手.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/09
 */
public class ElasticsearchQueryHelper {

    private ElasticsearchQueryHelper() {
    }

    /**
     * 创建查询
     *
     * @return 查询
     */
    public static <T extends BaseDocument> QueryParam<T> buildQuery(Class<T> documentType) {
        return new QueryParam<>(documentType);
    }

    /**
     * 创建检索
     *
     * @return 查询
     */
    public static <T extends BaseDocument> SearchParam<T> buildSearch(Class<T> documentType) {
        return new SearchParam<>(documentType);
    }

    /**
     * 创建聚合
     *
     * @param documentType 文档类型
     * @param <T>          文档类型
     * @return 聚合参数
     */
    public static <T extends BaseDocument> AggregationParam<T> buildAggregation(Class<T> documentType) {
        return new AggregationParam<>(documentType);
    }

    /**
     * 查询条件构造器
     *
     * @param documentType 文档类型
     * @param <T>          文档类型
     * @return 条件构造器
     */
    public static <T extends BaseDocument> ConditionBuilder<T> conditionBuilder(Class<T> documentType) {
        return new ConditionBuilder<>(documentType);
    }

    /**
     * 顺序条件构造器
     *
     * @param documentType 文档类型
     * @param <T>          文档类型
     * @return 条件构造器
     */
    public static <T extends BaseDocument> OrderBuilder<T> orderBuilder(Class<T> documentType) {
        return OrderBuilder.instance(documentType);
    }
}
