package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;
import org.springframework.data.domain.PageRequest;

/**
 * 查询时的参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/06
 */
public class QueryParam<T extends BaseDocument> extends AbstractDocumentParam<T> {

    /**
     * 过滤器
     */
    private ConditionBuilder<T> filterBuilder;
    /**
     * 排序
     * 当用于检索时，使用相关性得分排序，设置该值无效
     */
    private OrderBuilder<T> orderBuilder;


    public QueryParam(Class<T> documentType) {
        super(documentType);
    }

    public QueryParam<T> withConditionFilter(ConditionBuilder<T> filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public QueryParam<T> withOrder(OrderBuilder<T> orderBuilder) {
        this.orderBuilder = orderBuilder;
        return this;
    }

    public QueryParam<T> withPageRequest(PageRequest pageRequest) {
        if (pageRequest == null) {
            return this;
        }
        this.page = pageRequest.getPageNumber() + 1;
        this.pageSize = pageRequest.getPageSize();

        var sort = pageRequest.getSort();
        if (sort.isSorted()) {
            orderBuilder = OrderBuilder.instance(documentType);
            sort.stream().forEach(order -> orderBuilder.order(order.isAscending() ? Order.ASC : Order.DESC, order.getProperty()));
        }

        return this;
    }

    public ConditionBuilder<T> getFilterBuilder() {
        return filterBuilder;
    }

    public OrderBuilder<T> getOrderBuilder() {
        return orderBuilder;
    }

}
