package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;
import org.springframework.data.domain.PageRequest;

/**
 * 数据检索时的参数.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/06
 */
public class SearchParam<T extends BaseDocument> extends AbstractDocumentParam<T> {

    /**
     * 过滤器
     */
    private ConditionBuilder<T> filterBuilder;
    /**
     * 条件
     * 用于相关性得分的计算
     */
    private ConditionBuilder<T> queryBuilder;

    public SearchParam(Class<T> documentType) {
        super(documentType);
    }

    public SearchParam<T> withConditionFilter(ConditionBuilder<T> filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public SearchParam<T> withConditionQuery(ConditionBuilder<T> queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public SearchParam<T> withPageRequest(PageRequest pageRequest) {
        if (pageRequest == null) {
            return this;
        }
        this.page = pageRequest.getPageNumber() + 1;
        this.pageSize = pageRequest.getPageSize();

        return this;
    }

    public ConditionBuilder<T> getFilterBuilder() {
        return filterBuilder;
    }

    public ConditionBuilder<T> getQueryBuilder() {
        return queryBuilder;
    }
}
