package com.elitesland.boot.elasticsearch.support;

import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.service.ElasticsearchClientServiceSimpleImpl;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

/**
 * 服务实例代理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/26
 */
public class ClientServiceProxy<T extends BaseDocument, E> extends ElasticsearchClientServiceSimpleImpl<T, E> implements InvocationHandler {

    public ClientServiceProxy(Class<T> docType, DocumentSupport documentSupport, ElasticsearchRestTemplate restTemplate) {
        super(docType, documentSupport, restTemplate);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke(this, args);
    }
}
