package com.elitesland.boot.elasticsearch.support;

import lombok.extern.slf4j.Slf4j;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

/**
 * Elasticsearch初始化.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/24
 */
@Slf4j
public class ElasticsearchInit {

    private final ElasticsearchRestTemplate template;
    private final String[] basePackages;

    public ElasticsearchInit(ElasticsearchRestTemplate template, String[] basePackages) {
        this.template = template;
        this.basePackages = basePackages;
    }

    public void execute() {
        // 检查索引
        var documentClass = new DocumentIndexCheck(template, basePackages).check();

        // 缓存索引配置
        DocumentIndexCache.init(documentClass);
    }
}
