package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import org.elasticsearch.action.update.UpdateHelper;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;

import java.util.HashMap;
import java.util.Map;

/**
 * 索引工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/08
 */
public class IndexSupportHelper {

    private final IndexOperations indexOperations;
    private final DocumentSupport documentSupport;

    public IndexSupportHelper(IndexOperations indexOperations, DocumentSupport documentSupport) {
        this.indexOperations = indexOperations;
        this.documentSupport = documentSupport;
    }

    public boolean updateMapping() {
        var mapping = indexOperations.createMapping();
        // 设置_source
        setMappingSource(mapping);

        return indexOperations.putMapping(mapping);
    }

    private void setMappingSource(Document mapping) {
        if (documentSupport != null) {
            Map<String, Object> source = new HashMap<>(8);

            // 是否禁用_source
            if (!documentSupport.sourceEnabled()) {
                source.put("enabled", false);

                mapping.put(UpdateHelper.ContextFields.SOURCE, source);
                return;
            }

            if (ArrayUtil.isNotEmpty(documentSupport.sourceIncludes())) {
                source.put("includes", documentSupport.sourceIncludes());
            }
            if (ArrayUtil.isNotEmpty(documentSupport.sourceExcludes())) {
                source.put("excludes", documentSupport.sourceExcludes());
            }
            mapping.put(UpdateHelper.ContextFields.SOURCE, source);
        }
    }
}
