package com.elitesland.boot.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.function.Consumer;

/**
 * 数据处理.
 *
 * @author Kaiser（wang shao）
 * @date 2021/07/16
 */
public class ObjectResolver {

    private ObjectResolver() {
    }

    /**
     * 解析数据
     *
     * @param source   待解析的数据
     * @param consumer 解析后的consumer
     */
    public static void resolve(Object source, Consumer<Object> consumer) {
        if (source == null) {
            return;
        }

        // 判断是否是集合
        if (source instanceof Collection) {
            for (Object val : (Collection<?>) source) {
                consumer.accept(val);
            }
            return;
        }

        // 判断是否是数组
        if (source.getClass().isArray()) {
            for (int i = 0, size = Array.getLength(source); i < size; i++) {
                consumer.accept(Array.get(source, i));
            }
            return;
        }

        // 其它简单数据类型
        consumer.accept(source);
    }
}
