/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.canal.config.support;

import cn.hutool.core.util.StrUtil;
import com.elitesland.boot.elasticsearch.canal.config.support.CanalHandlerCustomizer;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class DefaultCanalHandler
implements CanalHandlerCustomizer {
    protected static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    protected static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    @Override
    public void objectMapperBuilder(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        jacksonObjectMapperBuilder.simpleDateFormat("yyyy-MM-dd HH:mm:ss");
        jacksonObjectMapperBuilder.serializerByType(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(FORMATTER_DATETIME));
        jacksonObjectMapperBuilder.deserializerByType(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(FORMATTER_DATETIME));
        jacksonObjectMapperBuilder.serializerByType(LocalDate.class, (JsonSerializer)new LocalDateSerializer(FORMATTER_DATE));
        jacksonObjectMapperBuilder.deserializerByType(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(FORMATTER_DATE));
        jacksonObjectMapperBuilder.failOnUnknownProperties(false);
    }

    @Override
    public String fieldNameConvert(String fieldName) {
        return StrUtil.toCamelCase((CharSequence)fieldName);
    }
}

