/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.persistence.MappedSuperclass;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.core.completion.Completion;

@MappedSuperclass
public abstract class BaseDocument
implements Serializable {
    private static final long serialVersionUID = 2204292204587067788L;
    @Id
    @Field(type=FieldType.Long)
    private Long id;
    @Field(type=FieldType.Date, format=DateFormat.date_hour_minute_second)
    private LocalDateTime createTime;
    @CompletionField(analyzer="ik_max_word", searchAnalyzer="ik_smart", maxInputLength=60)
    private Completion completion;

    public Long getId() {
        return this.id;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public Completion getCompletion() {
        return this.completion;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setCompletion(Completion completion) {
        this.completion = completion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDocument)) {
            return false;
        }
        BaseDocument other = (BaseDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        LocalDateTime this$createTime = this.getCreateTime();
        LocalDateTime other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Completion this$completion = this.getCompletion();
        Completion other$completion = other.getCompletion();
        return !(this$completion == null ? other$completion != null : !this$completion.equals(other$completion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        LocalDateTime $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Completion $completion = this.getCompletion();
        result = result * 59 + ($completion == null ? 43 : $completion.hashCode());
        return result;
    }

    public String toString() {
        return "BaseDocument(id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", completion=" + this.getCompletion() + ")";
    }
}

