/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common;

import com.elitesland.boot.elasticsearch.common.BaseDocument;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageResult<T extends BaseDocument>
implements Serializable {
    private static final long serialVersionUID = 7338596361008811849L;
    private long total;
    private List<T> recordList;

    public PageResult(long total, List<T> recordList) {
        this.total = Math.max(total, 0L);
        this.recordList = recordList == null ? Collections.emptyList() : recordList;
    }

    public PageResult() {
        this.total = 0L;
        this.recordList = Collections.emptyList();
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public List<T> getRecordList() {
        return this.recordList;
    }

    public <R> List<R> getRecordList(Function<T, R> convert) {
        if (this.recordList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.recordList.stream().map(convert).collect(Collectors.toList());
    }

    public void setRecordList(List<T> recordList) {
        this.recordList = recordList;
    }
}

