/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;

public abstract class AbstractDocumentParam<T extends BaseDocument> {
    protected final Class<T> documentType;
    protected int page = 1;
    protected int pageSize = 10;

    public AbstractDocumentParam(Class<T> documentType) {
        this.documentType = documentType;
    }

    public AbstractDocumentParam<T> withPage(int page) {
        this.page = Math.max(1, page);
        return this;
    }

    public AbstractDocumentParam<T> withPageSize(int pageSize) {
        this.pageSize = Math.max(1, pageSize);
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }
}

