/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common.query;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.common.query.QueryParamValueConvert;
import com.elitesland.boot.elasticsearch.support.DocumentIndexCache;
import com.elitesland.boot.elasticsearch.support.FieldWrapper;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class ConditionBuilder<T extends BaseDocument> {
    private final BoolQueryBuilder queryBuilder;
    private final Class<T> documentType;
    private final DocumentIndexCache.DocumentIndex documentIndex;
    private final QueryParamValueConvert paramValueConvert = new QueryParamValueConvert();
    private static final Set<FieldType> FIELD_TYPE_SUPPORT_TERM = new HashSet<FieldType>(64);

    ConditionBuilder(Class<T> clazz) {
        this.queryBuilder = QueryBuilders.boolQuery();
        this.documentType = clazz;
        this.documentIndex = DocumentIndexCache.getDocumentIndex(clazz);
        Assert.notNull((Object)this.documentIndex, (String)"\u6784\u5efa\u67e5\u8be2\u6761\u4ef6\u5931\u8d25", (Object[])new Object[0]);
    }

    public ConditionBuilder<T> and(String field, Object value) {
        return this.and(true, field, value, true);
    }

    public ConditionBuilder<T> and(String field, Object value, boolean match) {
        return this.and(match, field, value, true);
    }

    public ConditionBuilder<T> andGt(String field, Object value) {
        return this.gt(true, field, value, false, true);
    }

    public ConditionBuilder<T> andGt(String field, Object value, boolean match) {
        return this.gt(match, field, value, false, true);
    }

    public ConditionBuilder<T> andGte(String field, Object value) {
        return this.gt(true, field, value, true, true);
    }

    public ConditionBuilder<T> andGte(String field, Object value, boolean match) {
        return this.gt(match, field, value, true, true);
    }

    public ConditionBuilder<T> andLt(String field, Object value) {
        return this.lt(true, field, value, false, true);
    }

    public ConditionBuilder<T> andLt(String field, Object value, boolean match) {
        return this.lt(match, field, value, false, true);
    }

    public ConditionBuilder<T> andLte(String field, Object value) {
        return this.lt(true, field, value, true, true);
    }

    public ConditionBuilder<T> andLte(String field, Object value, boolean match) {
        return this.lt(match, field, value, true, true);
    }

    public ConditionBuilder<T> andBetween(String field, Object from, boolean includeFrom, Object to, boolean includeTo) {
        return this.between(true, field, from, includeFrom, to, includeTo, true);
    }

    public ConditionBuilder<T> andBetween(String field, Object from, boolean includeFrom, Object to, boolean includeTo, boolean match) {
        return this.between(match, field, from, includeFrom, to, includeTo, true);
    }

    public ConditionBuilder<T> and(ConditionBuilder<T> conditionBuilder) {
        return this.and(conditionBuilder, true);
    }

    public ConditionBuilder<T> and(ConditionBuilder<T> conditionBuilder, boolean match) {
        if (!match) {
            return this;
        }
        this.queryBuilder.must(conditionBuilder.build());
        return this;
    }

    public ConditionBuilder<T> andNot(String field, Object value) {
        return this.and(true, field, value, false);
    }

    public ConditionBuilder<T> andNot(String field, Object value, boolean match) {
        return this.and(match, field, value, false);
    }

    public ConditionBuilder<T> andNotEqual(ConditionBuilder<T> conditionBuilder) {
        return this.andNotEqual(conditionBuilder, true);
    }

    public ConditionBuilder<T> andNotEqual(ConditionBuilder<T> conditionBuilder, boolean match) {
        if (!match) {
            return this;
        }
        this.queryBuilder.mustNot(conditionBuilder.build());
        return this;
    }

    public ConditionBuilder<T> or(String field, Object value) {
        return this.or(true, field, value);
    }

    public ConditionBuilder<T> or(String field, Object value, boolean match) {
        return this.or(match, field, value);
    }

    public ConditionBuilder<T> orGt(String field, Object value) {
        return this.gt(true, field, value, false, false);
    }

    public ConditionBuilder<T> orGt(String field, Object value, boolean match) {
        return this.gt(match, field, value, false, false);
    }

    public ConditionBuilder<T> orGte(String field, Object value) {
        return this.gt(true, field, value, true, false);
    }

    public ConditionBuilder<T> orGte(String field, Object value, boolean match) {
        return this.gt(match, field, value, true, false);
    }

    public ConditionBuilder<T> orLt(String field, Object value) {
        return this.lt(true, field, value, false, false);
    }

    public ConditionBuilder<T> orLt(String field, Object value, boolean match) {
        return this.lt(match, field, value, false, false);
    }

    public ConditionBuilder<T> orLte(String field, Object value) {
        return this.lt(true, field, value, true, false);
    }

    public ConditionBuilder<T> orLte(String field, Object value, boolean match) {
        return this.lt(match, field, value, true, false);
    }

    public ConditionBuilder<T> orBetween(String field, Object from, boolean includeFrom, Object to, boolean includeTo) {
        return this.between(true, field, from, includeFrom, to, includeTo, false);
    }

    public ConditionBuilder<T> orBetween(String field, Object from, boolean includeFrom, Object to, boolean includeTo, boolean match) {
        return this.between(match, field, from, includeFrom, to, includeTo, false);
    }

    public ConditionBuilder<T> or(ConditionBuilder<T> conditionBuilder) {
        return this.or(conditionBuilder, true);
    }

    public ConditionBuilder<T> or(ConditionBuilder<T> conditionBuilder, boolean match) {
        if (!match) {
            return this;
        }
        this.queryBuilder.should(conditionBuilder.build());
        return this;
    }

    public QueryBuilder build() {
        return this.queryBuilder;
    }

    private ConditionBuilder<T> and(boolean match, String field, Object value, boolean equal) {
        MatchQueryBuilder builder;
        if (!match || StrUtil.isBlank((CharSequence)field)) {
            return this;
        }
        Object object = builder = this.supportTerm(field, value) ? QueryBuilders.termQuery((String)field, (Object)this.convertValue(field, value)) : QueryBuilders.matchQuery((String)field, (Object)value);
        if (equal) {
            this.queryBuilder.must((QueryBuilder)builder);
        } else {
            this.queryBuilder.mustNot((QueryBuilder)builder);
        }
        return this;
    }

    public ConditionBuilder<T> or(boolean match, String field, Object value) {
        if (!match || StrUtil.isBlank((CharSequence)field)) {
            return this;
        }
        MatchQueryBuilder builder = this.supportTerm(field, value) ? QueryBuilders.termQuery((String)field, (Object)this.convertValue(field, value)) : QueryBuilders.matchQuery((String)field, (Object)value);
        this.queryBuilder.should((QueryBuilder)builder);
        return this;
    }

    private ConditionBuilder<T> gt(boolean match, String field, Object value, boolean include, boolean and) {
        if (!match || StrUtil.isBlank((CharSequence)field) || value == null) {
            return this;
        }
        RangeQueryBuilder builder = QueryBuilders.rangeQuery((String)field);
        if (include) {
            builder.gt(this.convertValue(field, value));
        } else {
            builder.gte(this.convertValue(field, value));
        }
        if (and) {
            this.queryBuilder.must((QueryBuilder)builder);
        } else {
            this.queryBuilder.should((QueryBuilder)builder);
        }
        return this;
    }

    private ConditionBuilder<T> lt(boolean match, String field, Object value, boolean include, boolean and) {
        if (!match || StrUtil.isBlank((CharSequence)field) || value == null) {
            return this;
        }
        RangeQueryBuilder builder = QueryBuilders.rangeQuery((String)field);
        if (include) {
            builder.lt(this.convertValue(field, value));
        } else {
            builder.lte(this.convertValue(field, value));
        }
        if (and) {
            this.queryBuilder.must((QueryBuilder)builder);
        } else {
            this.queryBuilder.should((QueryBuilder)builder);
        }
        return this;
    }

    public ConditionBuilder<T> between(boolean match, String field, Object from, boolean includeFrom, Object to, boolean includeTo, boolean and) {
        if (!match || StrUtil.isBlank((CharSequence)field) || from == null && to == null) {
            return this;
        }
        RangeQueryBuilder builder = QueryBuilders.rangeQuery((String)field);
        if (from != null) {
            if (includeFrom) {
                builder.gte(this.convertValue(field, from));
            } else {
                builder.gt(this.convertValue(field, from));
            }
        }
        if (to != null) {
            if (includeTo) {
                builder.lte(this.convertValue(field, to));
            } else {
                builder.lt(this.convertValue(field, to));
            }
        }
        if (and) {
            this.queryBuilder.must((QueryBuilder)builder);
        } else {
            this.queryBuilder.should((QueryBuilder)builder);
        }
        return this;
    }

    private boolean supportTerm(String property, Object value) {
        boolean exists = this.documentIndex.getFields().contains(property);
        Assert.isTrue((boolean)exists, (String)"\u5728{}\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u5c5e\u6027{}", (Object[])new Object[]{this.documentType.getName(), property});
        FieldWrapper fieldWrapper = this.documentIndex.getFieldWrapperMap().get(property);
        Field field = fieldWrapper == null ? null : fieldWrapper.getElasticsearchField();
        Assert.notNull((Object)field, (String)"\u5728{}\u4e2d{}\u4e0d\u662f\u6709\u6548\u7684\u7d22\u5f15\u5b57\u6bb5", (Object[])new Object[]{this.documentType.getName(), property});
        exists = FIELD_TYPE_SUPPORT_TERM.contains(field.type());
        if (exists) {
            return true;
        }
        return value == null || value.toString().length() < field.ignoreAbove();
    }

    private Object convertValue(String property, Object value) {
        if (value == null) {
            return null;
        }
        FieldWrapper field = this.documentIndex.getFieldWrapperMap().get(property);
        Assert.notNull((Object)field, (String)"\u672a\u77e5\u5c5e\u6027{}", (Object[])new Object[]{property});
        return this.paramValueConvert.convert(field, value);
    }

    static {
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Keyword);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Long);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Integer);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Short);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Byte);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Double);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Float);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Half_Float);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Scaled_Float);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Date);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Date_Nanos);
        FIELD_TYPE_SUPPORT_TERM.add(FieldType.Boolean);
    }
}

