/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common.query;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.common.query.Order;
import com.elitesland.boot.elasticsearch.support.DocumentIndexCache;
import com.elitesland.boot.elasticsearch.support.FieldWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

public class OrderBuilder<T extends BaseDocument> {
    private final List<FieldSortBuilder> sortBuilders = new ArrayList<FieldSortBuilder>(32);
    private final Class<T> documentType;
    private final DocumentIndexCache.DocumentIndex documentIndex;
    private static final Set<FieldType> FIELD_TYPE_SUPPORT_ORDER = new HashSet<FieldType>(64);

    private OrderBuilder(Class<T> documentType) {
        this.documentType = documentType;
        this.documentIndex = DocumentIndexCache.getDocumentIndex(documentType);
    }

    public static <T extends BaseDocument> OrderBuilder<T> instance(Class<T> documentClass) {
        return new OrderBuilder<T>(documentClass);
    }

    public OrderBuilder<T> order(Order order, String ... fields) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return null;
        }
        for (String f : fields) {
            Assert.isTrue((boolean)this.support(f), (String)"{}\u4e0d\u662f\u6709\u6548\u7684\u6392\u5e8f\u5b57\u6bb5", (Object[])new Object[]{f});
            this.sortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)f).order(order == Order.ASC ? SortOrder.ASC : SortOrder.DESC));
        }
        return this;
    }

    public List<FieldSortBuilder> build() {
        return this.sortBuilders;
    }

    private boolean support(String property) {
        boolean exists = this.documentIndex.getFields().contains(property);
        Assert.isTrue((boolean)exists, (String)"\u5728{}\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u5c5e\u6027{}", (Object[])new Object[]{this.documentType.getName(), property});
        FieldWrapper fieldWrapper = this.documentIndex.getFieldWrapperMap().get(property);
        Field field = fieldWrapper == null ? null : fieldWrapper.getElasticsearchField();
        Assert.notNull((Object)field, (String)"\u5728{}\u4e2d{}\u4e0d\u662f\u6709\u6548\u7684\u7d22\u5f15\u5b57\u6bb5", (Object[])new Object[]{this.documentType.getName(), property});
        return FIELD_TYPE_SUPPORT_ORDER.contains(field.type());
    }

    static {
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Keyword);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Long);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Integer);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Short);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Byte);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Double);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Float);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Half_Float);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Scaled_Float);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Date);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Date_Nanos);
        FIELD_TYPE_SUPPORT_ORDER.add(FieldType.Boolean);
    }
}

