/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common.query;

import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.common.query.AbstractDocumentParam;
import com.elitesland.boot.elasticsearch.common.query.ConditionBuilder;
import com.elitesland.boot.elasticsearch.common.query.Order;
import com.elitesland.boot.elasticsearch.common.query.OrderBuilder;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;

public class QueryParam<T extends BaseDocument>
extends AbstractDocumentParam<T> {
    private ConditionBuilder<T> filterBuilder;
    private OrderBuilder<T> orderBuilder;

    public QueryParam(Class<T> documentType) {
        super(documentType);
    }

    public QueryParam<T> withConditionFilter(ConditionBuilder<T> filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public QueryParam<T> withOrder(OrderBuilder<T> orderBuilder) {
        this.orderBuilder = orderBuilder;
        return this;
    }

    public QueryParam<T> withPageRequest(PageRequest pageRequest) {
        if (pageRequest == null) {
            return this;
        }
        this.page = pageRequest.getPageNumber() + 1;
        this.pageSize = pageRequest.getPageSize();
        Sort sort = pageRequest.getSort();
        if (sort.isSorted()) {
            this.orderBuilder = OrderBuilder.instance(this.documentType);
            sort.stream().forEach(order -> this.orderBuilder.order(order.isAscending() ? Order.ASC : Order.DESC, order.getProperty()));
        }
        return this;
    }

    public ConditionBuilder<T> getFilterBuilder() {
        return this.filterBuilder;
    }

    public OrderBuilder<T> getOrderBuilder() {
        return this.orderBuilder;
    }
}

