/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.common.query;

import cn.hutool.core.lang.Assert;
import com.elitesland.boot.elasticsearch.support.FieldWrapper;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;

public class QueryParamValueConvert {
    private static final Logger logger = LoggerFactory.getLogger(QueryParamValueConvert.class);
    private static final Map<DateFormat, String> DATE_FORMAT = new EnumMap<DateFormat, String>(DateFormat.class);

    public Object convert(FieldWrapper field, Object value) {
        if (value instanceof Date || value instanceof TemporalAccessor) {
            return this.convertForDate(field, value);
        }
        return value;
    }

    private Object convertForDate(FieldWrapper field, Object value) {
        Field f = field.getElasticsearchField();
        DateFormat dateFormat = f.format();
        if (dateFormat == DateFormat.none) {
            return value;
        }
        if (dateFormat == DateFormat.custom) {
            Assert.notBlank((CharSequence)f.pattern(), (String)"{}\u7684@Field\u6ce8\u89e3\u4e2dpattern\u4e3a\u7a7a", (Object[])new Object[]{field.getFullName()});
            return this.formatDate(value, f.pattern());
        }
        String pattern = DATE_FORMAT.get(dateFormat);
        if (pattern != null) {
            return this.formatDate(value, pattern);
        }
        logger.warn("\u4e0d\u652f\u6301\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u7684\u5b57\u6bb5\uff1a{}.{}", (Object)field.getClazz().getName(), (Object)field.getFullName());
        return value;
    }

    private Object formatDate(Object value, String formatter) {
        return value instanceof Date ? new SimpleDateFormat(formatter).format((Date)value) : DateTimeFormatter.ofPattern(formatter).format((TemporalAccessor)value);
    }

    static {
        DATE_FORMAT.put(DateFormat.basic_date, "yyyyMMdd");
        DATE_FORMAT.put(DateFormat.basic_date_time, "yyyyMMdd'T'HHmmss.SSSZ");
        DATE_FORMAT.put(DateFormat.basic_date_time_no_millis, "yyyyDDD'T'HHmmssZ");
        DATE_FORMAT.put(DateFormat.basic_ordinal_date, "yyyyDDD");
        DATE_FORMAT.put(DateFormat.basic_ordinal_date_time, "yyyyDDD'T'HHmmss.SSSZ");
        DATE_FORMAT.put(DateFormat.basic_ordinal_date_time_no_millis, "yyyyDDD'T'HHmmssZ");
        DATE_FORMAT.put(DateFormat.basic_time, "HHmmss.SSSZ");
        DATE_FORMAT.put(DateFormat.basic_time_no_millis, "HHmmssZ");
        DATE_FORMAT.put(DateFormat.basic_t_time, "'T'HHmmss.SSSZ");
        DATE_FORMAT.put(DateFormat.basic_t_time_no_millis, "'T'HHmmssZ");
        DATE_FORMAT.put(DateFormat.basic_week_date, "xxxx'W'wwe");
        DATE_FORMAT.put(DateFormat.basic_week_date_time, "xxxx'W'wwe'T'HHmmss.SSSZ");
        DATE_FORMAT.put(DateFormat.basic_week_date_time_no_millis, "xxxx'W'wwe'T'HHmmssZ");
        DATE_FORMAT.put(DateFormat.date, "yyyy-MM-dd");
        DATE_FORMAT.put(DateFormat.date_hour, "yyyy-MM-dd'T'HH");
        DATE_FORMAT.put(DateFormat.date_hour_minute, "yyyy-MM-dd'T'HH:mm");
        DATE_FORMAT.put(DateFormat.date_hour_minute_second, "yyyy-MM-dd'T'HH:mm:ss");
        DATE_FORMAT.put(DateFormat.date_hour_minute_second_fraction, "yyyy-MM-dd'T'HH:mm:ss.SSS");
        DATE_FORMAT.put(DateFormat.date_hour_minute_second_millis, "yyyy-MM-dd'T'HH:mm:ss.SSS");
        DATE_FORMAT.put(DateFormat.date_optional_time, "yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        DATE_FORMAT.put(DateFormat.date_time, "yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        DATE_FORMAT.put(DateFormat.date_time_no_millis, "yyyy-MM-dd'T'HH:mm:ssZZ");
        DATE_FORMAT.put(DateFormat.hour, "HH");
        DATE_FORMAT.put(DateFormat.hour_minute, "HH:mm");
        DATE_FORMAT.put(DateFormat.hour_minute_second, "HH:mm:ss");
        DATE_FORMAT.put(DateFormat.hour_minute_second_fraction, "HH:mm:ss.SSS");
        DATE_FORMAT.put(DateFormat.hour_minute_second_millis, "HH:mm:ss.SSS");
        DATE_FORMAT.put(DateFormat.ordinal_date, "yyyy-DDD");
        DATE_FORMAT.put(DateFormat.ordinal_date_time, "yyyy-DDD'T'HH:mm:ss.SSSZZ");
        DATE_FORMAT.put(DateFormat.ordinal_date_time_no_millis, "yyyy-DDD'T'HH:mm:ssZZ");
        DATE_FORMAT.put(DateFormat.time, "HH:mm:ss.SSSZZ");
        DATE_FORMAT.put(DateFormat.time_no_millis, "HH:mm:ssZZ");
        DATE_FORMAT.put(DateFormat.t_time, "'T'HH:mm:ss.SSSZZ");
        DATE_FORMAT.put(DateFormat.t_time_no_millis, "'T'HH:mm:ssZZ");
        DATE_FORMAT.put(DateFormat.week_date, "xxxx-'W'ww-e");
        DATE_FORMAT.put(DateFormat.week_date_time, "xxxx-'W'ww-e'T'HH:mm:ss.SSSZZ");
        DATE_FORMAT.put(DateFormat.weekDateTimeNoMillis, "xxxx-'W'ww-e'T'HH:mm:ssZZ");
        DATE_FORMAT.put(DateFormat.week_year, "xxxx");
        DATE_FORMAT.put(DateFormat.weekyearWeek, "xxxx-'W'ww");
        DATE_FORMAT.put(DateFormat.weekyearWeekDay, "xxxx-'W'ww-e");
        DATE_FORMAT.put(DateFormat.year, "yyyy");
        DATE_FORMAT.put(DateFormat.year_month, "yyyy-MM");
        DATE_FORMAT.put(DateFormat.year_month_day, "yyyy-MM-dd");
    }
}

