/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.config;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.boot.elasticsearch.ElasticsearchClientService;
import com.elitesland.boot.elasticsearch.annotation.DocumentService;
import com.elitesland.boot.elasticsearch.support.ClientServiceFactory;
import com.elitesland.boot.util.ClassPathBeanScanner;
import java.beans.Introspector;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.Role;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;

@Role(value=2)
public class ElasticsearchClientRegister
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchClientRegister.class);
    private final String[] basePackages;

    public ElasticsearchClientRegister(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (ArrayUtil.isEmpty((Object[])this.basePackages)) {
            logger.warn("\u6ce8\u518c Elasticsearch Client Service \u5931\u8d25\uff1a{}", (Object)Arrays.toString(this.basePackages));
            return;
        }
        logger.info("start register Elasticsearch Client Service\uff0cscan packages\uff1a{}", (Object)Arrays.toString(this.basePackages));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Set<Class<?>> classSet = null;
        try {
            classSet = this.scan(this.basePackages);
        }
        catch (Exception exception) {
            throw new BeanCreationException("\u52a0\u8f7d Elasticsearch Client Service \u5931\u8d25\uff1a", (Throwable)exception);
        }
        this.registry(beanFactory, classSet);
        stopWatch.stop();
        logger.info("finish register {} Elasticsearch Client Service in {}ms", (Object)classSet.size(), (Object)stopWatch.getTotalTimeMillis());
    }

    private Set<Class<?>> scan(String[] basePackage) {
        String clazzName = ElasticsearchClientService.class.getName();
        return new ClassPathBeanScanner(basePackage).filter(metadataReader -> metadataReader.getClassMetadata().isInterface() && ArrayUtil.contains((Object[])metadataReader.getClassMetadata().getInterfaceNames(), (Object)clazzName)).scan(t -> {
            try {
                return Class.forName(t.getClassMetadata().getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private void registry(ConfigurableListableBeanFactory configurableListableBeanFactory, Set<Class<?>> classSet) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        for (Class<?> clazz : classSet) {
            GenericBeanDefinition beanDefinition = (GenericBeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(clazz).getRawBeanDefinition();
            beanDefinition.setBeanClass(ClientServiceFactory.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(clazz);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue(this.getDocType(clazz));
            beanDefinition.getPropertyValues().add("restTemplate", (Object)new RuntimeBeanReference("elasticsearchTemplate"));
            beanDefinition.setAutowireMode(2);
            String beanName = this.generateBeanName(clazz);
            logger.info("registered Elasticsearch Client Service\uff1a{}", (Object)beanName);
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        }
    }

    private Class<?> getDocType(Class<?> clazz) {
        try {
            return (Class)((ParameterizedType)clazz.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("\u6ce8\u518cElasticsearch Client Service\u5931\u8d25\uff1a" + clazz.getName());
        }
    }

    private String generateBeanName(Class<?> clazz) {
        String beanName;
        Object[] docServices = (DocumentService[])clazz.getAnnotationsByType(DocumentService.class);
        if (ArrayUtil.isNotEmpty((Object[])docServices) && StrUtil.isNotBlank((CharSequence)(beanName = docServices[0].value()))) {
            return beanName;
        }
        String shortName = ClassUtils.getShortName(clazz);
        return Introspector.decapitalize(shortName);
    }
}

