/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitesland.boot.elasticsearch.ElasticsearchClientService;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.common.PageResult;
import com.elitesland.boot.elasticsearch.common.query.AbstractDocumentParam;
import com.elitesland.boot.elasticsearch.common.query.AggregationParam;
import com.elitesland.boot.elasticsearch.common.query.QueryParam;
import com.elitesland.boot.elasticsearch.common.query.SearchParam;
import com.elitesland.boot.elasticsearch.service.handler.DocumentSaveHandler;
import com.elitesland.boot.elasticsearch.support.IndexSupportHelper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.util.Assert;

@NoRepositoryBean
public class ElasticsearchClientServiceSimpleImpl<T extends BaseDocument, E>
implements ElasticsearchClientService<T, E> {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchClientServiceSimpleImpl.class);
    private final Class<T> docType;
    private final DocumentSupport documentSupport;
    private final ElasticsearchRestTemplate restTemplate;
    private final IndexOperations indexOperations;
    private final IndexCoordinates indexCoordinates;
    private static final String FIELD_COMPLETION = "completion";

    public ElasticsearchClientServiceSimpleImpl(Class<T> docType, DocumentSupport documentSupport, ElasticsearchRestTemplate restTemplate) {
        this.docType = docType;
        this.documentSupport = documentSupport;
        this.restTemplate = restTemplate;
        this.indexOperations = restTemplate.indexOps(docType);
        this.indexCoordinates = restTemplate.getIndexCoordinatesFor(docType);
    }

    @Override
    public String getIndexName() {
        return this.indexCoordinates.getIndexName();
    }

    @Override
    public boolean indexExists() {
        return this.indexOperations.exists();
    }

    @Override
    public boolean indexCreate() {
        boolean exists = this.indexOperations.exists();
        if (exists) {
            return true;
        }
        exists = this.indexOperations.create();
        if (exists) {
            new IndexSupportHelper(this.indexOperations, this.documentSupport).updateMapping();
        }
        return exists;
    }

    @Override
    public boolean indexUpdate() {
        boolean exists = this.indexOperations.exists();
        if (!exists) {
            exists = this.indexOperations.create();
        }
        if (exists) {
            new IndexSupportHelper(this.indexOperations, this.documentSupport).updateMapping();
        }
        return exists;
    }

    @Override
    public boolean indexDelete() {
        if (!this.indexOperations.exists()) {
            return true;
        }
        return this.indexOperations.delete();
    }

    @Override
    public T documentSave(T document) {
        if (document == null) {
            throw new IllegalArgumentException("\u6587\u6863\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            document = new DocumentSaveHandler<T>(this.docType).beforeSave(document);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Elasticsearch\u6570\u636e\u6821\u9a8c\u5931\u8d25", exception);
        }
        return (T)((BaseDocument)this.restTemplate.save(document));
    }

    @Override
    public List<T> documentSave(List<T> documentList) {
        if (CollUtil.isEmpty(documentList)) {
            return Collections.emptyList();
        }
        documentList = documentList.parallelStream().map(t -> {
            try {
                return new DocumentSaveHandler<BaseDocument>(this.docType).beforeSave((BaseDocument)t);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Elasticsearch\u6570\u636e\u6821\u9a8c\u5931\u8d25", exception);
            }
        }).collect(Collectors.toList());
        this.restTemplate.save(documentList);
        return documentList;
    }

    @Override
    public boolean documentExists(E id) {
        if (id == null) {
            throw new IllegalArgumentException("\u6587\u6863\u6807\u8bc6\u4e3a\u7a7a");
        }
        return this.restTemplate.exists(id.toString(), this.indexCoordinates);
    }

    @Override
    public T documentGet(E id) {
        if (id == null) {
            throw new IllegalArgumentException("\u6587\u6863\u6807\u8bc6\u4e3a\u7a7a");
        }
        return (T)((BaseDocument)this.restTemplate.get(id.toString(), this.docType, this.indexCoordinates));
    }

    @Override
    public List<T> documentGet(List<E> idList) {
        if (CollUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List ids = idList.stream().map(Objects::toString).distinct().collect(Collectors.toList());
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder().withIds(ids);
        return this.restTemplate.multiGet((Query)queryBuilder.build(), this.docType, this.indexCoordinates);
    }

    @Override
    public boolean documentDelete(E id) {
        if (id == null) {
            throw new IllegalArgumentException("\u6587\u6863\u6807\u8bc6\u4e3a\u7a7a");
        }
        this.restTemplate.delete(id.toString(), this.indexCoordinates);
        return true;
    }

    @Override
    public boolean documentDelete(List<E> idList) {
        if (CollUtil.isEmpty(idList)) {
            return true;
        }
        List ids = idList.stream().map(Objects::toString).distinct().collect(Collectors.toList());
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder().withIds(ids);
        this.restTemplate.delete((Query)queryBuilder.build(), this.docType, this.indexCoordinates);
        return true;
    }

    @Override
    public PageResult<T> documentQuery(QueryParam<T> queryParam) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        queryBuilder.withFilter(queryParam.getFilterBuilder() == null ? null : queryParam.getFilterBuilder().build());
        if (queryParam.getOrderBuilder() != null) {
            for (FieldSortBuilder b : queryParam.getOrderBuilder().build()) {
                queryBuilder.withSort((SortBuilder)b);
            }
        }
        queryBuilder.withPageable((Pageable)this.obtainPageRequest(queryParam));
        SearchHits searchHits = this.restTemplate.search((Query)queryBuilder.build(), this.docType, this.indexCoordinates);
        List records = searchHits.hasSearchHits() ? searchHits.getSearchHits().stream().map(SearchHit::getContent).collect(Collectors.toList()) : Collections.emptyList();
        return new PageResult(searchHits.getTotalHits(), records);
    }

    @Override
    public PageResult<T> documentSearch(SearchParam<T> searchParam) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        queryBuilder.withFilter(searchParam.getFilterBuilder() == null ? null : searchParam.getFilterBuilder().build());
        queryBuilder.withQuery(searchParam.getQueryBuilder() == null ? null : searchParam.getQueryBuilder().build());
        queryBuilder.withSort((SortBuilder)SortBuilders.scoreSort());
        queryBuilder.withPageable((Pageable)this.obtainPageRequest(searchParam));
        SearchHits searchHits = this.restTemplate.search((Query)queryBuilder.build(), this.docType, this.indexCoordinates);
        List records = searchHits.hasSearchHits() ? searchHits.getSearchHits().stream().map(SearchHit::getContent).collect(Collectors.toList()) : Collections.emptyList();
        return new PageResult(searchHits.getTotalHits(), records);
    }

    @Override
    public Aggregations aggregationSearch(AggregationParam<T> aggregationParam) {
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        if (aggregationParam.getFilterBuilder() != null) {
            queryBuilder.withFilter(aggregationParam.getFilterBuilder().build());
        }
        Assert.notEmpty(aggregationParam.getAggregationBuilders(), (String)"\u8bf7\u914d\u7f6e\u805a\u5408\u53c2\u6570");
        for (AbstractAggregationBuilder agg : aggregationParam.getAggregationBuilders()) {
            queryBuilder.addAggregation(agg);
        }
        queryBuilder.withPageable((Pageable)PageRequest.of((int)0, (int)1));
        SearchHits searchHits = this.restTemplate.search((Query)queryBuilder.build(), this.docType, this.indexCoordinates);
        return searchHits.getAggregations();
    }

    @Override
    public List<String> suggestComplete(String prefix, Integer size) {
        if (CharSequenceUtil.isBlank((CharSequence)prefix)) {
            return Collections.emptyList();
        }
        if (size == null || size < 1) {
            size = 10;
        }
        CompletionSuggestionBuilder completionSuggestBuilder = (CompletionSuggestionBuilder)SuggestBuilders.completionSuggestion((String)FIELD_COMPLETION).prefix(prefix).skipDuplicates(true).size(size.intValue());
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        suggestBuilder.addSuggestion("suggest", (SuggestionBuilder)completionSuggestBuilder);
        return this.restTemplate.suggest(suggestBuilder, this.indexCoordinates).getSuggest().getSuggestion("suggest").getEntries().stream().flatMap(t -> t.getOptions().stream().map(tt -> tt.getText().toString())).collect(Collectors.toList());
    }

    private PageRequest obtainPageRequest(AbstractDocumentParam<T> param) {
        int page = Math.max(1, param.getPage()) - 1;
        int pageSize = Math.max(1, param.getPageSize());
        pageSize = Math.min(pageSize, 1000);
        return PageRequest.of((int)page, (int)pageSize);
    }
}

