/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.service.handler;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.support.DocumentIndexCache;
import com.elitesland.boot.elasticsearch.support.FieldWrapper;
import com.elitesland.boot.util.ObjectResolver;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.core.completion.Completion;

public class DocumentSaveHandler<T extends BaseDocument> {
    private final Class<T> documentType;
    private final DocumentIndexCache.DocumentIndex documentIndex;

    public DocumentSaveHandler(Class<T> documentType) {
        this.documentType = documentType;
        this.documentIndex = DocumentIndexCache.getDocumentIndex(documentType);
        Assert.notNull((Object)this.documentIndex, (String)"\u7d22\u5f15\u6570\u636e\u5931\u8d25\uff0c\u521d\u59cb\u5316\u5f02\u5e38", (Object[])new Object[0]);
    }

    public T beforeSave(T document) throws Exception {
        Assert.notNull((Object)((BaseDocument)document).getId(), (String)"\u6587\u6863\u7684\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean needFilter = this.documentIndex.isNeedFilter();
        if (!needFilter) {
            return document;
        }
        HashSet<String> completionValues = new HashSet<String>(64);
        for (FieldWrapper field : this.documentIndex.getFieldWrapperMap().values()) {
            this.obtainCompletionValue(document, field, completionValues);
            this.eraseValue(document, field);
        }
        this.writeCompletionValue(document, completionValues);
        if (((BaseDocument)document).getCreateTime() == null) {
            ((BaseDocument)document).setCreateTime(LocalDateTime.now());
        }
        return document;
    }

    private void writeCompletionValue(T document, Set<String> completionValues) {
        if (completionValues.isEmpty()) {
            return;
        }
        ((BaseDocument)document).setCompletion(new Completion(new ArrayList<String>(completionValues)));
    }

    private void eraseValue(T document, FieldWrapper fieldWrapper) throws Exception {
        if (!fieldWrapper.isIgnore()) {
            return;
        }
        if (fieldWrapper.isPrimitive()) {
            Assert.isTrue((boolean)this.isTransient(fieldWrapper.getField()), (String)"{}\u8bf7\u4f7f\u7528\u5305\u88c5\u7c7b\u578b", (Object[])new Object[]{fieldWrapper.getField().toGenericString()});
        }
        this.erase(document, null, fieldWrapper);
    }

    private void erase(Object source, String fieldPrefix, FieldWrapper fieldWrapper) throws Exception {
        if (StrUtil.equals((CharSequence)fieldPrefix, (CharSequence)fieldWrapper.getNamePrefix())) {
            fieldWrapper.getPropertyDescriptor().getWriteMethod().invoke(source, new Object[]{null});
            return;
        }
        String propertyName = DocumentSaveHandler.obtainPropertyName(fieldWrapper.getFullName(), fieldPrefix);
        String fieldName = (String)(fieldPrefix == null ? "" : fieldPrefix + ".") + propertyName;
        Object value = this.documentIndex.getFieldWrapperMap().get(fieldName).getPropertyDescriptor().getReadMethod().invoke(source, new Object[0]);
        ObjectResolver.resolve(value, t -> {
            try {
                this.erase(t, fieldName, fieldWrapper);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        });
    }

    private void obtainCompletionValue(T document, FieldWrapper fieldWrapper, Set<String> completionValues) throws Exception {
        if (!fieldWrapper.isCompletionSource()) {
            return;
        }
        this.completionValue(document, null, fieldWrapper, completionValues);
    }

    private void completionValue(Object source, String fieldPrefix, FieldWrapper fieldWrapper, Set<String> completionValues) throws Exception {
        if (StrUtil.equals((CharSequence)fieldPrefix, (CharSequence)fieldWrapper.getNamePrefix())) {
            Object value = fieldWrapper.getPropertyDescriptor().getReadMethod().invoke(source, new Object[0]);
            ObjectResolver.resolve(value, t -> completionValues.add((String)t));
            return;
        }
        String propertyName = DocumentSaveHandler.obtainPropertyName(fieldWrapper.getFullName(), fieldPrefix);
        String fieldName = (String)(fieldPrefix == null ? "" : fieldPrefix + ".") + propertyName;
        Object value = this.documentIndex.getFieldWrapperMap().get(fieldName).getPropertyDescriptor().getReadMethod().invoke(source, new Object[0]);
        ObjectResolver.resolve(value, t -> {
            try {
                this.completionValue(t, fieldPrefix, fieldWrapper, completionValues);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        });
    }

    private boolean isTransient(Field field) {
        return field.isAnnotationPresent(Transient.class);
    }

    private static String obtainPropertyName(String str, String prefix) {
        int offset;
        if (prefix == null) {
            return str.substring(0, str.indexOf("."));
        }
        int index = str.indexOf(".", offset = prefix.length() + 1);
        return str.substring(offset, index == -1 ? str.length() : index);
    }
}

