/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.support.ClientServiceProxy;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;

public class ClientServiceFactory<B, T extends BaseDocument, E>
implements FactoryBean<B> {
    private final Class<B> target;
    private final Class<T> docType;
    private final DocumentSupport documentSupport;
    private ElasticsearchRestTemplate restTemplate;

    public ClientServiceFactory(Class<B> target, Class<T> docType) {
        this.target = target;
        this.docType = docType;
        Object[] documentSupports = (DocumentSupport[])docType.getAnnotationsByType(DocumentSupport.class);
        this.documentSupport = ArrayUtil.isEmpty((Object[])documentSupports) ? null : documentSupports[0];
        this.validate(docType, this.documentSupport);
    }

    public B getObject() throws Exception {
        return (B)Proxy.newProxyInstance(this.target.getClassLoader(), new Class[]{this.target}, new ClientServiceProxy(this.docType, this.documentSupport, this.restTemplate));
    }

    public Class<?> getObjectType() {
        return this.target;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRestTemplate(ElasticsearchRestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private void validate(Class<T> docType, DocumentSupport documentSupport) {
        if (documentSupport == null) {
            throw new IllegalArgumentException("\u5728\u3010" + docType.getName() + "\u3011\u4e0a\u672a\u627e\u5230@DocumentSupport()\u7684\u6ce8\u89e3\uff01");
        }
        this.validateCompletion(docType, documentSupport);
    }

    private void validateCompletion(Class<T> docType, DocumentSupport documentSupport) {
        Object[] fields = documentSupport.completionFields();
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return;
        }
        Object[] properties = ReflectUtils.getBeanProperties(docType);
        boolean validated = true;
        if (ArrayUtil.isEmpty((Object[])properties)) {
            validated = false;
        } else {
            Map<String, PropertyDescriptor> propertiesMap = Arrays.stream(properties).collect(Collectors.toMap(FeatureDescriptor::getName, t -> t, (t1, t2) -> t1));
            HashSet<Object> existsField = new HashSet<Object>(fields.length);
            for (Object f : fields) {
                PropertyDescriptor property = propertiesMap.get(f);
                if (property == null || property.getReadMethod() == null || property.getWriteMethod() == null || existsField.contains(f)) {
                    validated = false;
                    break;
                }
                existsField.add(f);
            }
        }
        if (!validated) {
            throw new IllegalArgumentException("\u5728\u3010" + docType.getName() + "\u3011\u4e2d\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
    }
}

