/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import com.elitesland.boot.elasticsearch.common.BaseDocument;
import com.elitesland.boot.elasticsearch.support.FieldWrapper;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.core.completion.Completion;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.util.StopWatch;

public class DocumentIndexCache {
    private static final Logger logger = LoggerFactory.getLogger(DocumentIndexCache.class);
    private static final Map<String, DocumentIndex> CACHE = new HashMap<String, DocumentIndex>(64);
    private static SimpleTypeHolder simpleTypeHolder = null;
    private static final Set<Class<?>> IGNORE_FIELD_TYPE = new HashSet(64);

    private DocumentIndexCache() {
    }

    public static void init(Set<Class<?>> classSet) {
        if (CollUtil.isEmpty(classSet)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Class<BaseDocument> clazzBase = BaseDocument.class;
        for (Class<?> clazz : classSet) {
            if (!clazzBase.isAssignableFrom(clazz)) continue;
            CACHE.put(clazz.getName(), DocumentIndexCache.buildDocumentIndex(clazz));
        }
        stopWatch.stop();
        logger.info("Elasticsearch document index config cache loaded finished for {} in {} ms", (Object)classSet.size(), (Object)stopWatch.getTotalTimeMillis());
    }

    public static DocumentIndex getDocumentIndex(Class<?> clazz) {
        return CACHE.get(clazz.getName());
    }

    private static DocumentIndex buildDocumentIndex(Class<?> clazz) {
        DocumentIndex documentIndex = new DocumentIndex();
        documentIndex.setDocumentSupport(DocumentIndexCache.obtainDocumentSupport(clazz));
        documentIndex.setFields(new HashSet<String>(64));
        documentIndex.setFieldWrapperMap(new HashMap<String, FieldWrapper>(64));
        DocumentIndexCache.analyseObjectProperty(documentIndex, clazz, null);
        DocumentIndexCache.setNeedFilter(documentIndex);
        return documentIndex;
    }

    private static void setNeedFilter(DocumentIndex documentIndex) {
        if (ArrayUtil.isNotEmpty((Object[])documentIndex.getDocumentSupport().completionFields())) {
            documentIndex.setNeedFilter(true);
            return;
        }
        boolean needIgnore = documentIndex.getFieldWrapperMap().values().stream().anyMatch(FieldWrapper::isIgnore);
        documentIndex.setNeedFilter(needIgnore);
    }

    private static void verifyAnnotation(Field field, org.springframework.data.elasticsearch.annotations.Field annotation) {
        if (annotation == null) {
            return;
        }
        boolean validate = false;
        if (DocumentIndexCache.isSimpleType(field.getType())) {
            validate = annotation.type() == FieldType.Object || annotation.type() == FieldType.Nested;
            Assert.isFalse((boolean)validate, (String)"{}\u4e0d\u652f\u6301\u4f7f\u7528\u6ce8\u89e3\uff1a{}", (Object[])new Object[]{field.toGenericString(), annotation.type()});
        }
    }

    private static void analyseObject(DocumentIndex documentIndex, Field field, org.springframework.data.elasticsearch.annotations.Field annotation, String fieldPrefix) {
        DocumentIndexCache.verifyAnnotation(field, annotation);
        Class type = field.getType();
        if (type.isArray()) {
            type = type.getComponentType();
        } else if (Collection.class.isAssignableFrom(type)) {
            Object[] types = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            Assert.isFalse((boolean)ArrayUtil.isEmpty((Object[])types), (String)"{}\u7684\u7c7b\u578b\u4e0d\u660e\u786e", (Object[])new Object[]{field.toGenericString()});
            type = (Class)types[0];
        }
        if (DocumentIndexCache.isSimpleType(type)) {
            return;
        }
        DocumentIndexCache.analyseObjectProperty(documentIndex, type, fieldPrefix);
    }

    private static void analyseObjectProperty(DocumentIndex documentIndex, Class<?> clazz, String fieldPrefix) {
        if (IGNORE_FIELD_TYPE.contains(clazz)) {
            return;
        }
        Object[] properties = ReflectUtils.getBeanProperties(clazz);
        Object[] fields = ReflectUtil.getFields(clazz);
        if (ArrayUtil.isEmpty((Object[])properties) || ArrayUtil.isEmpty((Object[])fields)) {
            return;
        }
        Map<String, Field> fieldMap = Arrays.stream(fields).collect(Collectors.toMap(Field::getName, t -> t, (t1, t2) -> t1));
        FieldWrapper fieldWrapper = null;
        for (Object p : properties) {
            fieldWrapper = new FieldWrapper(documentIndex.getDocumentSupport(), clazz, fieldPrefix, fieldMap.get(((FeatureDescriptor)p).getName()), (PropertyDescriptor)p, simpleTypeHolder);
            documentIndex.getFieldWrapperMap().put(fieldWrapper.getFullName(), fieldWrapper);
            DocumentIndexCache.analyseObject(documentIndex, fieldWrapper.getField(), fieldWrapper.getElasticsearchField(), fieldWrapper.getFullName());
            if (fieldWrapper.isIgnore()) continue;
            documentIndex.getFields().add(fieldWrapper.getFullName());
        }
    }

    private static DocumentSupport obtainDocumentSupport(Class<?> clazz) {
        Object[] annotations = (DocumentSupport[])clazz.getAnnotationsByType(DocumentSupport.class);
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            return null;
        }
        return annotations[0];
    }

    private static boolean isSimpleType(Class<?> type) {
        return simpleTypeHolder.isSimpleType(type);
    }

    static {
        HashSet<Class> customSimpleSet = new HashSet<Class>(64);
        customSimpleSet.add(BigDecimal.class);
        customSimpleSet.add(LocalDateTime.class);
        customSimpleSet.add(LocalDate.class);
        customSimpleSet.add(LocalTime.class);
        simpleTypeHolder = new SimpleTypeHolder(customSimpleSet, true);
        IGNORE_FIELD_TYPE.add(Completion.class);
    }

    public static class DocumentIndex {
        private DocumentSupport documentSupport;
        private Set<String> fields = Collections.emptySet();
        private Map<String, FieldWrapper> fieldWrapperMap = Collections.emptyMap();
        private boolean needFilter;

        void setDocumentSupport(DocumentSupport documentSupport) {
            this.documentSupport = documentSupport;
        }

        void setFields(Set<String> fields) {
            this.fields = fields;
        }

        void setFieldWrapperMap(Map<String, FieldWrapper> fieldWrapperMap) {
            this.fieldWrapperMap = fieldWrapperMap;
        }

        void setNeedFilter(boolean needFilter) {
            this.needFilter = needFilter;
        }

        public DocumentSupport getDocumentSupport() {
            return this.documentSupport;
        }

        public Set<String> getFields() {
            return this.fields;
        }

        public Map<String, FieldWrapper> getFieldWrapperMap() {
            return this.fieldWrapperMap;
        }

        public boolean isNeedFilter() {
            return this.needFilter;
        }
    }
}

