/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import com.elitesland.boot.elasticsearch.support.IndexSupportHelper;
import com.elitesland.boot.util.ClassPathBeanScanner;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.util.StopWatch;

class DocumentIndexCheck {
    private static final Logger logger = LoggerFactory.getLogger(DocumentIndexCheck.class);
    private final ElasticsearchRestTemplate template;
    private final String[] basePackages;
    private static final Class<DocumentSupport> ANNOTATION = DocumentSupport.class;

    public DocumentIndexCheck(ElasticsearchRestTemplate template, String[] basePackages) {
        this.template = template;
        this.basePackages = basePackages;
    }

    public Set<Class<?>> check() {
        if (ArrayUtil.isEmpty((Object[])this.basePackages) || this.template == null) {
            logger.warn("Elasticsearch Document Index check fail\uff1a{}\uff0c{}", (Object)(this.template == null ? 1 : 0), (Object)this.basePackages);
            return Collections.emptySet();
        }
        logger.info("start scan Elasticsearch document package\uff1a{}", (Object)Arrays.toString(this.basePackages));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Set<Class<?>> entitySet = null;
        try {
            entitySet = this.scanPackageByAnnotation(this.basePackages);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Elasticsearch document\u5b9e\u4f53\u521d\u59cb\u5316\u5931\u8d25", e);
        }
        for (Class<?> cls : entitySet) {
            this.checkIndex(cls);
        }
        stopWatch.stop();
        logger.info("finish scan Elasticsearch document in {}ms", (Object)stopWatch.getTotalTimeMillis());
        return entitySet;
    }

    private void checkIndex(Class<?> clazz) {
        Object[] annotations = (DocumentSupport[])clazz.getAnnotationsByType(ANNOTATION);
        if (ArrayUtil.isEmpty((Object[])annotations)) {
            throw new RuntimeException("\u7d22\u5f15Elasticsearch\u7d22\u5f15\u68c0\u67e5\u5931\u8d25");
        }
        Object annotation = annotations[0];
        switch (annotation.checkStrategy()) {
            case NO_CHECK: {
                this.noCheck(clazz);
                break;
            }
            case CREATE_IF_NO_EXIST: {
                this.createIfNotExist(clazz, (DocumentSupport)annotation);
                break;
            }
            case ALWAYS_UPDATE: {
                this.alwaysUpdate(clazz, (DocumentSupport)annotation);
                break;
            }
        }
    }

    private Set<Class<?>> scanPackageByAnnotation(String[] packageNames) throws RuntimeException {
        String annotationName = ANNOTATION.getName();
        String documentAnnotationName = Document.class.getName();
        return new ClassPathBeanScanner(packageNames).filter(metadataReader -> metadataReader.getAnnotationMetadata().hasAnnotation(annotationName) && metadataReader.getAnnotationMetadata().hasAnnotation(documentAnnotationName)).scan(t -> {
            try {
                return Class.forName(t.getClassMetadata().getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    private void noCheck(Class<?> index) {
        boolean exists = false;
        try {
            IndexOperations indexOperations = this.template.indexOps(index);
            exists = indexOperations.exists();
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u7d22\u5f15\u3010{}\u3011\u662f\u5426\u5b58\u5728\u5931\u8d25\uff1a{}", (Object)index.getName(), (Object)e.getMessage());
            return;
        }
        logger.info("index\u3010{}\u3011exists\uff1a{}", (Object)index.getName(), (Object)exists);
    }

    private void createIfNotExist(Class<?> index, DocumentSupport documentSupport) {
        try {
            IndexOperations indexOperations = this.template.indexOps(index);
            if (indexOperations.exists()) {
                logger.info("index\u3010{}\u3011 has exists", (Object)index.getName());
                return;
            }
            boolean created = indexOperations.create();
            if (created) {
                new IndexSupportHelper(indexOperations, documentSupport).updateMapping();
            }
            logger.info("index\u3010{}\u3011 has updated\uff1a{}", (Object)index.getName(), (Object)created);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u7d22\u5f15\u3010{}\u3011\u662f\u5426\u5b58\u5728\u5931\u8d25\uff1a{}", (Object)index.getName(), (Object)e.getMessage());
        }
    }

    private void alwaysUpdate(Class<?> index, DocumentSupport documentSupport) {
        try {
            IndexOperations indexOperations = this.template.indexOps(index);
            boolean exists = indexOperations.exists();
            if (!exists) {
                exists = indexOperations.create();
            }
            if (exists) {
                new IndexSupportHelper(indexOperations, documentSupport).updateMapping();
            }
            logger.info("index\u3010{}\u3011 has updated\uff1a{}", (Object)index.getName(), (Object)exists);
        }
        catch (Exception e) {
            logger.error("\u68c0\u67e5\u7d22\u5f15\u3010{}\u3011\u662f\u5426\u5b58\u5728\u5931\u8d25\uff1a{}", (Object)index.getName(), (Object)e.getMessage());
        }
    }
}

