/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class FieldWrapper {
    private DocumentSupport documentSupport;
    private Class<?> clazz;
    private String namePrefix;
    private java.lang.reflect.Field field;
    private PropertyDescriptor propertyDescriptor;
    private SimpleTypeHolder simpleTypeHolder;
    private String name;
    private String fullName;
    private Class<?> actualType;
    private Field elasticsearchField;
    private boolean ignore;
    private boolean completionSource;
    private boolean primitive;
    private boolean simple;
    private boolean array;
    private boolean collection;

    public FieldWrapper(DocumentSupport documentSupport, Class<?> clazz, String namePrefix, java.lang.reflect.Field field, PropertyDescriptor propertyDescriptor, SimpleTypeHolder simpleTypeHolder) {
        this.documentSupport = documentSupport;
        this.clazz = clazz;
        this.namePrefix = namePrefix;
        this.field = field;
        this.propertyDescriptor = propertyDescriptor;
        this.simpleTypeHolder = simpleTypeHolder;
        this.init();
    }

    private void init() {
        this.name = this.propertyDescriptor.getName();
        this.fullName = this.namePrefix == null ? this.name : this.namePrefix + "." + this.name;
        this.elasticsearchField = (Field)ArrayUtil.get((Object)this.field.getAnnotationsByType(Field.class), (int)0);
        this.ignore = this.elasticsearchField == null;
        this.dealType();
        this.dealCompletion();
    }

    private void dealType() {
        Class<?> type = this.propertyDescriptor.getPropertyType();
        this.primitive = type.isPrimitive();
        this.simple = this.simpleTypeHolder.isSimpleType(type);
        this.array = type.isArray();
        this.collection = Collection.class.isAssignableFrom(type);
        if (this.primitive || this.simple) {
            this.actualType = type;
        } else if (this.array) {
            this.actualType = type.getComponentType();
        } else if (Collection.class.isAssignableFrom(type)) {
            Object[] types = ((ParameterizedType)this.field.getGenericType()).getActualTypeArguments();
            Assert.isFalse((boolean)ArrayUtil.isEmpty((Object[])types), (String)"{}\u7684\u7c7b\u578b\u4e0d\u660e\u786e", (Object[])new Object[]{this.field.toGenericString()});
            this.actualType = (Class)types[0];
        } else {
            this.actualType = type;
        }
    }

    private void dealCompletion() {
        Set completionFields;
        Set set = completionFields = ArrayUtil.isEmpty((Object[])this.documentSupport.completionFields()) ? Collections.emptySet() : Arrays.stream(this.documentSupport.completionFields()).collect(Collectors.toSet());
        if (completionFields.isEmpty()) {
            return;
        }
        this.completionSource = completionFields.contains(this.fullName);
        if (this.completionSource) {
            Assert.isTrue((boolean)String.class.isAssignableFrom(this.actualType), (String)"{}\u5b57\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u52a8\u8865\u5168\u5b57\u6bb5", (Object[])new Object[0]);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public java.lang.reflect.Field getField() {
        return this.field;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public SimpleTypeHolder getSimpleTypeHolder() {
        return this.simpleTypeHolder;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Field getElasticsearchField() {
        return this.elasticsearchField;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public Class<?> getActualType() {
        return this.actualType;
    }

    public boolean isCompletionSource() {
        return this.completionSource;
    }

    public DocumentSupport getDocumentSupport() {
        return this.documentSupport;
    }

    public void setDocumentSupport(DocumentSupport documentSupport) {
        this.documentSupport = documentSupport;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setField(java.lang.reflect.Field field) {
        this.field = field;
    }

    public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypeHolder) {
        this.simpleTypeHolder = simpleTypeHolder;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setActualType(Class<?> actualType) {
        this.actualType = actualType;
    }

    public void setElasticsearchField(Field elasticsearchField) {
        this.elasticsearchField = elasticsearchField;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setCompletionSource(boolean completionSource) {
        this.completionSource = completionSource;
    }

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldWrapper)) {
            return false;
        }
        FieldWrapper other = (FieldWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnore() != other.isIgnore()) {
            return false;
        }
        if (this.isCompletionSource() != other.isCompletionSource()) {
            return false;
        }
        if (this.isPrimitive() != other.isPrimitive()) {
            return false;
        }
        if (this.isSimple() != other.isSimple()) {
            return false;
        }
        if (this.isArray() != other.isArray()) {
            return false;
        }
        if (this.isCollection() != other.isCollection()) {
            return false;
        }
        DocumentSupport this$documentSupport = this.getDocumentSupport();
        DocumentSupport other$documentSupport = other.getDocumentSupport();
        if (this$documentSupport == null ? other$documentSupport != null : !this$documentSupport.equals(other$documentSupport)) {
            return false;
        }
        Class<?> this$clazz = this.getClazz();
        Class<?> other$clazz = other.getClazz();
        if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
            return false;
        }
        String this$namePrefix = this.getNamePrefix();
        String other$namePrefix = other.getNamePrefix();
        if (this$namePrefix == null ? other$namePrefix != null : !this$namePrefix.equals(other$namePrefix)) {
            return false;
        }
        java.lang.reflect.Field this$field = this.getField();
        java.lang.reflect.Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        PropertyDescriptor this$propertyDescriptor = this.getPropertyDescriptor();
        PropertyDescriptor other$propertyDescriptor = other.getPropertyDescriptor();
        if (this$propertyDescriptor == null ? other$propertyDescriptor != null : !((Object)this$propertyDescriptor).equals(other$propertyDescriptor)) {
            return false;
        }
        SimpleTypeHolder this$simpleTypeHolder = this.getSimpleTypeHolder();
        SimpleTypeHolder other$simpleTypeHolder = other.getSimpleTypeHolder();
        if (this$simpleTypeHolder == null ? other$simpleTypeHolder != null : !this$simpleTypeHolder.equals(other$simpleTypeHolder)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fullName = this.getFullName();
        String other$fullName = other.getFullName();
        if (this$fullName == null ? other$fullName != null : !this$fullName.equals(other$fullName)) {
            return false;
        }
        Class<?> this$actualType = this.getActualType();
        Class<?> other$actualType = other.getActualType();
        if (this$actualType == null ? other$actualType != null : !this$actualType.equals(other$actualType)) {
            return false;
        }
        Field this$elasticsearchField = this.getElasticsearchField();
        Field other$elasticsearchField = other.getElasticsearchField();
        return !(this$elasticsearchField == null ? other$elasticsearchField != null : !this$elasticsearchField.equals(other$elasticsearchField));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnore() ? 79 : 97);
        result = result * 59 + (this.isCompletionSource() ? 79 : 97);
        result = result * 59 + (this.isPrimitive() ? 79 : 97);
        result = result * 59 + (this.isSimple() ? 79 : 97);
        result = result * 59 + (this.isArray() ? 79 : 97);
        result = result * 59 + (this.isCollection() ? 79 : 97);
        DocumentSupport $documentSupport = this.getDocumentSupport();
        result = result * 59 + ($documentSupport == null ? 43 : $documentSupport.hashCode());
        Class<?> $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        String $namePrefix = this.getNamePrefix();
        result = result * 59 + ($namePrefix == null ? 43 : $namePrefix.hashCode());
        java.lang.reflect.Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        PropertyDescriptor $propertyDescriptor = this.getPropertyDescriptor();
        result = result * 59 + ($propertyDescriptor == null ? 43 : ((Object)$propertyDescriptor).hashCode());
        SimpleTypeHolder $simpleTypeHolder = this.getSimpleTypeHolder();
        result = result * 59 + ($simpleTypeHolder == null ? 43 : $simpleTypeHolder.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fullName = this.getFullName();
        result = result * 59 + ($fullName == null ? 43 : $fullName.hashCode());
        Class<?> $actualType = this.getActualType();
        result = result * 59 + ($actualType == null ? 43 : $actualType.hashCode());
        Field $elasticsearchField = this.getElasticsearchField();
        result = result * 59 + ($elasticsearchField == null ? 43 : $elasticsearchField.hashCode());
        return result;
    }

    public String toString() {
        return "FieldWrapper(documentSupport=" + this.getDocumentSupport() + ", clazz=" + this.getClazz() + ", namePrefix=" + this.getNamePrefix() + ", field=" + this.getField() + ", propertyDescriptor=" + this.getPropertyDescriptor() + ", simpleTypeHolder=" + this.getSimpleTypeHolder() + ", name=" + this.getName() + ", fullName=" + this.getFullName() + ", actualType=" + this.getActualType() + ", elasticsearchField=" + this.getElasticsearchField() + ", ignore=" + this.isIgnore() + ", completionSource=" + this.isCompletionSource() + ", primitive=" + this.isPrimitive() + ", simple=" + this.isSimple() + ", array=" + this.isArray() + ", collection=" + this.isCollection() + ")";
    }
}

