/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.elasticsearch.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitesland.boot.elasticsearch.annotation.DocumentSupport;
import java.util.HashMap;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.document.Document;

public class IndexSupportHelper {
    private final IndexOperations indexOperations;
    private final DocumentSupport documentSupport;

    public IndexSupportHelper(IndexOperations indexOperations, DocumentSupport documentSupport) {
        this.indexOperations = indexOperations;
        this.documentSupport = documentSupport;
    }

    public boolean updateMapping() {
        Document mapping = this.indexOperations.createMapping();
        this.setMappingSource(mapping);
        return this.indexOperations.putMapping(mapping);
    }

    private void setMappingSource(Document mapping) {
        if (this.documentSupport != null) {
            HashMap<String, Object> source = new HashMap<String, Object>(8);
            if (!this.documentSupport.sourceEnabled()) {
                source.put("enabled", false);
                mapping.put((Object)"_source", source);
                return;
            }
            if (ArrayUtil.isNotEmpty((Object[])this.documentSupport.sourceIncludes())) {
                source.put("includes", this.documentSupport.sourceIncludes());
            }
            if (ArrayUtil.isNotEmpty((Object[])this.documentSupport.sourceExcludes())) {
                source.put("excludes", this.documentSupport.sourceExcludes());
            }
            mapping.put((Object)"_source", source);
        }
    }
}

