/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.boot.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;

public class ClassPathBeanScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathBeanScanner.class);
    private final String[] packageNames;
    private Function<MetadataReader, Boolean> filter;

    public ClassPathBeanScanner(String ... packageNames) {
        this.packageNames = packageNames;
    }

    public ClassPathBeanScanner filter(Function<MetadataReader, Boolean> filter) {
        this.filter = filter;
        return this;
    }

    public Set<String> scan() {
        return this.scan(metadataReader -> metadataReader.getClassMetadata().getClassName());
    }

    public <T> Set<T> scan(@NonNull Function<MetadataReader, T> convert) {
        if (convert == null) {
            throw new NullPointerException("convert is marked non-null but is null");
        }
        ResourcePatternResolver pathResolver = ResourcePatternUtils.getResourcePatternResolver(null);
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)pathResolver);
        return Arrays.stream(this.packageNames).flatMap(arg_0 -> this.lambda$scan$1(pathResolver, (MetadataReaderFactory)metadataReaderFactory, convert, arg_0)).collect(Collectors.toSet());
    }

    private <T> Set<T> scan(ResourcePatternResolver pathResolver, MetadataReaderFactory metadataReaderFactory, Function<MetadataReader, T> convert, String packageName) throws IOException {
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)packageName) + "/**/*.class";
        return ((Stream)Arrays.stream(pathResolver.getResources(pattern)).parallel()).map(res -> {
            try {
                return metadataReaderFactory.getMetadataReader(res);
            }
            catch (IOException e) {
                logger.error("ElasticsearchStarter \u52a0\u8f7d\u8d44\u6e90\u8fc7\u7a0b\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }).filter((? super T t) -> t != null && (this.filter == null || this.filter.apply((MetadataReader)t) != false)).map(convert).collect(Collectors.toSet());
    }

    private /* synthetic */ Stream lambda$scan$1(ResourcePatternResolver pathResolver, MetadataReaderFactory metadataReaderFactory, Function convert, String p) {
        try {
            return this.scan(pathResolver, metadataReaderFactory, convert, p).stream();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u52a0\u8f7dElasticsearch Client Service \u52a0\u8f7d\u5931\u8d25\uff1a", e);
        }
    }
}

