/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.data.etl.transform.template.controller;

import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.elitesland.cbpl.data.etl.transform.template.service.TransformTemplateService;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplatePagingParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplateSaveParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TemplatePagingVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TransformTemplateVO;
import com.elitesland.cbpl.data.etl.util.DataETL;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.db.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ETL-\u8f6c\u6362\u6a21\u677f\u8868"})
@RestController
@RequestMapping(value={"/etl/transform"})
public class TransformTemplateController {
    private static final Logger logger = LoggerFactory.getLogger(TransformTemplateController.class);
    private final TransformTemplateService transformTemplateService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public HttpResult<PagingVO<TemplatePagingVO>> list(@RequestBody TemplatePagingParamVO query) {
        logger.info("[TransformTemplate] query paging param = {}", (Object)query);
        return HttpResult.ok(this.transformTemplateService.transformTemplatePageBy(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public HttpResult<TransformTemplateVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[TransformTemplate] query detail by id = {}", (Object)id);
        return HttpResult.ok((Object)this.transformTemplateService.transformTemplateById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public HttpResult<Long> save(@RequestBody TemplateSaveParamVO saveParam) {
        logger.info("[TransformTemplate] create/update record, saveParam = {}", (Object)saveParam);
        return HttpResult.ok((Object)this.transformTemplateService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public HttpResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[TransformTemplate] active by id = {}", (Object)id);
        this.transformTemplateService.updateStatus(id, 1);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public HttpResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[TransformTemplate] inactive by id = {}", (Object)id);
        this.transformTemplateService.updateStatus(id, 0);
        return HttpResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public HttpResult<Long> delete(@RequestBody List<Long> ids) {
        logger.info("[TransformTemplate] batch physical delete by ids = {}", ids);
        return HttpResult.ok((Object)this.transformTemplateService.delete(ids));
    }

    @ApiOperation(value="\u6d4b\u8bd5\u9a8c\u8bc1\u6570\u636e\u8f6c\u6362\u7ed3\u679c")
    @PostMapping(value={"/verify"})
    public Object verify(String templateCode, @RequestBody Object data) {
        String result = DataETL.transform(templateCode, data);
        return JSONUtil.wrap((Object)result, (JSONConfig)new JSONConfig());
    }

    public TransformTemplateController(TransformTemplateService transformTemplateService) {
        this.transformTemplateService = transformTemplateService;
    }
}

