/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.data.etl.transform.template.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.data.etl.transform.template.entity.QTransformTemplateDO;
import com.elitesland.cbpl.data.etl.transform.template.vo.param.TemplatePagingParamVO;
import com.elitesland.cbpl.data.etl.transform.template.vo.resp.TemplatePagingVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TransformTemplateRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QTransformTemplateDO transformTemplateDO = QTransformTemplateDO.transformTemplateDO;
    private final QBean<TemplatePagingVO> transformTemplatePagingVO;

    private Predicate pagingWhere(TemplatePagingParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(TransformTemplateRepoProc.transformTemplateDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getTemplateCode())) {
            predicates.add(TransformTemplateRepoProc.transformTemplateDO.templateCode.eq((Object)query.getTemplateCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTemplateName())) {
            String likeStr = SqlUtil.toSqlLikeString((String)query.getTemplateName());
            predicates.add(TransformTemplateRepoProc.transformTemplateDO.templateName.like(likeStr));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(TransformTemplateRepoProc.transformTemplateDO.status.eq((Object)query.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(TransformTemplateRepoProc.transformTemplateDO.remark.eq((Object)query.getRemark()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long transformTemplateCountBy(TemplatePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(TransformTemplateRepoProc.transformTemplateDO.id).from((EntityPath)transformTemplateDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<TemplatePagingVO> transformTemplatePageBy(TemplatePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.transformTemplatePagingVO).from((EntityPath)transformTemplateDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, transformTemplateDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    public long delete(List<Long> ids) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)transformTemplateDO).where(new Predicate[]{TransformTemplateRepoProc.transformTemplateDO.id.in(ids)});
        return delete.execute();
    }

    public long updateStatus(Long id, Integer status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)transformTemplateDO).set(TransformTemplateRepoProc.transformTemplateDO.status, (Object)status).where(new Predicate[]{TransformTemplateRepoProc.transformTemplateDO.id.eq((Object)id)});
        return update.execute();
    }

    public TransformTemplateRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.transformTemplatePagingVO = Projections.bean(TemplatePagingVO.class, (Expression[])new Expression[]{TransformTemplateRepoProc.transformTemplateDO.id, TransformTemplateRepoProc.transformTemplateDO.templateCode, TransformTemplateRepoProc.transformTemplateDO.templateName, TransformTemplateRepoProc.transformTemplateDO.status, TransformTemplateRepoProc.transformTemplateDO.remark, TransformTemplateRepoProc.transformTemplateDO.createUserId, TransformTemplateRepoProc.transformTemplateDO.creator, TransformTemplateRepoProc.transformTemplateDO.createTime, TransformTemplateRepoProc.transformTemplateDO.modifyUserId, TransformTemplateRepoProc.transformTemplateDO.updater, TransformTemplateRepoProc.transformTemplateDO.modifyTime});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

