package com.elitesland.cbpl.infinity.server.account.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepo;
import com.elitesland.cbpl.infinity.server.account.repo.InfinityAccountRepoProc;
import com.elitesland.cbpl.infinity.server.account.vo.resp.InfinityAccountRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/05/30
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityAccountServiceImpl implements InfinityAccountService {

    private final InfinityAccountRepo infinityAccountRepo;
    private final InfinityAccountRepoProc infinityAccountRepoProc;

    @Override
    public List<InfinityAccountRespVO> queryAccounts(String username) {
        return infinityAccountRepoProc.queryAccounts(username);
    }

    @Override
    public InfinityAccountRespVO queryOneAccount(String username) {
        List<InfinityAccountRespVO> accounts = queryAccounts(username);
        if (accounts.size() > 1) {
            throw new BusinessException("[INFINITY-ACCOUNT] account not unique: " + username);
        }
        return accounts.get(0);
    }
}
