package com.elitesland.cbpl.infinity.server.router.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.cbpl.infinity.server.router.enums.AuthMethod;
import com.elitesland.cbpl.infinity.server.router.enums.ParseMethod;
import com.elitesland.cbpl.infinity.server.router.enums.ResponseType;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.persistence.*;
import java.io.Serializable;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Entity
@Table(name = "infinity_router")
@org.hibernate.annotations.Table(appliesTo = "infinity_router", comment = "接口定义表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class InfinityRouterDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -299135067584600769L;

    @Column()
    @Comment("认证表ID")
    private Long authId;

    @Column()
    @Comment("分组ID")
    private Long groupId;

    @Column()
    @Comment("接口编码")
    private String routerCode;

    @Column()
    @Comment("接口名称")
    private String routerName;

    @Column()
    @Comment("请求方式")
    @Enumerated(EnumType.STRING)
    private RequestMethod requestMethod;

    @Column()
    @Comment("接口地址")
    private String url;

    @Column()
    @Comment("接口动作：用于标识接口用途")
    private String action;

    @Column()
    @Comment("接口地址解析方式")
    @Enumerated(EnumType.STRING)
    private ParseMethod parseMethod;

    @Column()
    @Comment("认证方式")
    @Enumerated(EnumType.STRING)
    private AuthMethod authMethod;

    @Column()
    @Comment("body参数")
    private String bodyParam;

    @Column()
    @Comment("返回值类型")
    @Enumerated(EnumType.STRING)
    private ResponseType responseType;

    @Column()
    @Comment("是否需要授权认证")
    private String isAuth;
}
