package com.elitesland.cbpl.infinity.server.router.repo;

import com.elitesland.cbpl.infinity.server.platform.entity.QInfinityPlatformDO;
import com.elitesland.cbpl.infinity.server.router.entity.QInfinityRouterDO;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Repository
@RequiredArgsConstructor
public class InfinityRouterRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QInfinityPlatformDO Q_INFINITY_PLATFORM_DO = QInfinityPlatformDO.infinityPlatformDO;
    private static final QInfinityRouterDO Q_INFINITY_ROUTER_DO = QInfinityRouterDO.infinityRouterDO;

    /**
     * 查询任务接口
     */
    public List<InfinityRouterRespVO> queryApis(InfinityRouterParamVO param) {
        var query = jpaQueryFactory
                .select(Projections.bean(
                        InfinityRouterRespVO.class,
                        Q_INFINITY_ROUTER_DO.id,
                        Q_INFINITY_ROUTER_DO.authId,
                        Q_INFINITY_ROUTER_DO.groupId,
                        Q_INFINITY_ROUTER_DO.routerCode,
                        Q_INFINITY_ROUTER_DO.routerName,
                        Q_INFINITY_ROUTER_DO.requestMethod,
                        Q_INFINITY_ROUTER_DO.url,
                        Q_INFINITY_ROUTER_DO.parseMethod,
                        Q_INFINITY_ROUTER_DO.authMethod,
                        Q_INFINITY_ROUTER_DO.action,
                        Q_INFINITY_ROUTER_DO.bodyParam,
                        Q_INFINITY_ROUTER_DO.responseType,
                        Q_INFINITY_ROUTER_DO.isAuth,
                        Q_INFINITY_ROUTER_DO.remark
                ))
                .from(Q_INFINITY_ROUTER_DO)
                .leftJoin(Q_INFINITY_PLATFORM_DO).on(Q_INFINITY_PLATFORM_DO.id.eq(Q_INFINITY_ROUTER_DO.authId))
                .where(Q_INFINITY_ROUTER_DO.deleteFlag.eq(0));

        List<Predicate> predicates = new ArrayList<>();
        if (param.getAuthId() != null) {
            predicates.add(Q_INFINITY_ROUTER_DO.authId.eq(param.getAuthId()));
        }
        if (StringUtils.isNotBlank(param.getRouterCode())) {
            predicates.add(Q_INFINITY_ROUTER_DO.routerCode.eq(param.getRouterCode()));
        }
        if (StringUtils.isNotBlank(param.getBuCode())) {
            predicates.add(Q_INFINITY_PLATFORM_DO.buCode.eq(param.getBuCode()));
        }
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }
}

