package com.elitesland.cbpl.infinity.server.router.service;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.cbpl.infinity.server.router.vo.param.InfinityRouterParamVO;
import com.elitesland.cbpl.infinity.server.router.vo.resp.InfinityRouterRespVO;
import com.elitesland.cbpl.infinity.server.router.repo.InfinityRouterRepoProc;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/04/06
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InfinityRouterServiceImpl implements InfinityRouterService {

    private final InfinityRouterRepoProc routerRepoProc;

    @Override
    public List<InfinityRouterRespVO> queryApis(InfinityRouterParamVO param) {
        List<InfinityRouterRespVO> apis = routerRepoProc.queryApis(param);
        if (apis.isEmpty()) {
            throw new BusinessException("[INFINITY-ROUTER] http api not exist: " + param);
        }
        return apis;
    }

    @Override
    public InfinityRouterRespVO queryOneApi(InfinityRouterParamVO param) {
        List<InfinityRouterRespVO> apis = queryApis(param);
        if (apis.size() > 1) {
            throw new BusinessException("[INFINITY-ROUTER] http api not unique: " + param.toString());
        }
        return apis.get(0);
    }
}
