/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.logging.common.pipeline.console.service;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.logging.audit.data.vo.param.AuditQueryParamVO;
import com.elitesland.cbpl.logging.audit.domain.AuditLogVO;
import com.elitesland.cbpl.logging.common.config.LoggingProperty;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocDeleteParamVO;
import com.elitesland.cbpl.logging.common.data.vo.param.TrackDocQueryParamVO;
import com.elitesland.cbpl.logging.common.data.vo.resp.TrackDocRespVO;
import com.elitesland.cbpl.logging.common.domain.TrackDoc;
import com.elitesland.cbpl.logging.common.pipeline.PipelineService;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.annotation.UnicomTag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@UnicomTag(value="CONSOLE")
public class ConsolePipelineService
implements PipelineService {
    private static final Logger logger = LoggerFactory.getLogger(ConsolePipelineService.class);

    @Override
    public boolean consume(LoggingProperty property, TrackDoc trackDoc) {
        try {
            logger.info("[LOGGING] CONSOLE({}): {}", (Object)trackDoc.getTrackType(), (Object)BeanUtils.toJsonStr((Object)trackDoc));
            return true;
        }
        catch (Throwable throwable) {
            logger.error("[LOGGING] persistence console error", throwable);
            return false;
        }
    }

    @Override
    public PagingVO<TrackDocRespVO> trackDocPageBy(TrackDocQueryParamVO query) {
        return new PagingVO();
    }

    @Override
    public List<TrackDocRespVO> trackDocByParam(TrackDocQueryParamVO query) {
        return ListUtil.empty();
    }

    @Override
    public long trackDocDelete(TrackDocDeleteParamVO paramVO) {
        return 0L;
    }

    @Override
    public List<AuditLogVO> auditTrackByParam(AuditQueryParamVO query) {
        return ListUtil.empty();
    }
}

